/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.datasource;

import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.runtime.data.datasource.DataSourceType;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.datasource.DelegatingDataSource;
import org.springframework.jndi.JndiTemplate;

public class WMDataSource
extends DelegatingDataSource {
    private DataSourceType dataSourceType;
    private String serviceId;
    private String jndiName;
    @Autowired
    private ApplicationContext context;

    public DataSourceType getDataSourceType() {
        return this.dataSourceType;
    }

    public void setDataSourceType(DataSourceType dataSourceType) {
        this.dataSourceType = dataSourceType;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public void afterPropertiesSet() {
        super.setTargetDataSource(this.getRequiredDatasource());
        super.afterPropertiesSet();
    }

    private DataSource getRequiredDatasource() {
        DataSource dataSource;
        try {
            if (this.getDataSourceType() == DataSourceType.JNDI_DATASOURCE) {
                JndiTemplate jndiTemplate = new JndiTemplate();
                dataSource = (DataSource)jndiTemplate.lookup(this.getJndiName(), DataSource.class);
            } else {
                dataSource = (DataSource)this.context.getBean(this.serviceId + "WMManagedDataSource", DataSource.class);
            }
        }
        catch (NamingException e) {
            throw new WMRuntimeException(e.getMessage(), (Throwable)e);
        }
        return dataSource;
    }
}

