/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.export;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum DataType {
    BYTE((List)Arrays.asList(Byte.class.getName(), Byte.TYPE.getName())){}
    ,
    SHORT((List)Arrays.asList(Short.class.getName(), Short.TYPE.getName())){}
    ,
    INTEGER((List)Arrays.asList(Integer.class.getName(), Integer.TYPE.getName())){}
    ,
    LONG((List)Arrays.asList(Long.class.getName(), Long.TYPE.getName())){}
    ,
    BIG_INTEGER((List)Collections.singletonList(BigInteger.class.getName())){}
    ,
    FLOAT((List)Arrays.asList(Float.class.getName(), Float.TYPE.getName())){}
    ,
    DOUBLE((List)Arrays.asList(Double.class.getName(), Double.TYPE.getName())){}
    ,
    BIG_DECIMAL((List)Collections.singletonList(BigDecimal.class.getName())){}
    ,
    BOOLEAN((List)Arrays.asList(Boolean.class.getName(), Boolean.TYPE.getName())){}
    ,
    CHARACTER((List)Arrays.asList(Character.class.getName(), Character.TYPE.getName())){}
    ,
    STRING((List)Arrays.asList(String.class.getName(), Clob.class.getName())){}
    ,
    BLOB((List)Arrays.asList(Byte[].class.getName(), byte[].class.getName(), Blob.class.getName())){}
    ,
    DATE((List)Arrays.asList(java.util.Date.class.getName(), Date.class.getName(), Time.class.getName(), Timestamp.class.getName())){}
    ,
    DATETIME((List)Collections.singletonList(LocalDateTime.class.getName())){}
    ,
    OBJECT((List)Collections.singletonList(Object.class.getName())){}
    ,
    LIST((List)Collections.singletonList(List.class.getName())){};

    private final List<String> classNames;
    private static Map<String, DataType> classNameVsTypesMap;

    public static DataType valueFor(String value) {
        return classNameVsTypesMap.get(value);
    }

    private DataType(List<String> classNames) {
        this.classNames = classNames;
    }

    public List<String> getClassNames() {
        return this.classNames;
    }

    static {
        classNameVsTypesMap = new HashMap<String, DataType>();
        for (DataType types : DataType.values()) {
            for (String className : types.getClassNames()) {
                classNameVsTypesMap.put(className, types);
            }
        }
    }
}

