/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.export;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.commons.io.File;
import com.wavemaker.commons.util.WMIOUtils;
import com.wavemaker.runtime.data.export.ExportCellStyles;
import com.wavemaker.runtime.data.export.ExportOptions;
import com.wavemaker.runtime.data.export.ExportOptionsStrategy;
import com.wavemaker.runtime.data.export.ExportType;
import com.wavemaker.runtime.data.export.QueryExtractor;
import com.wavemaker.runtime.data.export.util.CSVConverterUtil;
import com.wavemaker.runtime.data.export.util.DataSourceExporterUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExportBuilder {
    private static final int FIRST_ROW_NUMBER = 0;
    private static final int FIRST_COLUMN_NUMBER = 0;
    private QueryExtractor queryExtractor;
    private ExportOptionsStrategy optionsStrategy;
    private ExportOptions options;
    private ExportCellStyles cellStyles;

    public ExportBuilder(QueryExtractor queryExtractor, ExportOptions options, Class<?> entityClass) {
        this.queryExtractor = queryExtractor;
        this.options = options;
        this.optionsStrategy = new ExportOptionsStrategy(options, entityClass);
    }

    public void build(OutputStream outputStream) {
        SXSSFWorkbook workbook = null;
        try {
            workbook = new SXSSFWorkbook();
            this.cellStyles = new ExportCellStyles((Workbook)workbook);
            SXSSFSheet spreadSheet = workbook.createSheet("Data");
            this.fillSheet((Sheet)spreadSheet);
            this.exportWorkbook((Workbook)workbook, this.options.getExportType(), outputStream);
        }
        catch (Exception e) {
            throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.export.building.error"), (Throwable)e);
        }
        finally {
            if (workbook != null) {
                workbook.dispose();
            }
            WMIOUtils.closeSilently((AutoCloseable)workbook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportWorkbook(Workbook workbook, ExportType exportType, OutputStream outputStream) {
        block24: {
            try {
                if (exportType == ExportType.EXCEL) {
                    workbook.write(outputStream);
                    break block24;
                }
                if (exportType != ExportType.CSV) break block24;
                File tempFile = WMIOUtils.createTempFile((String)"export", (String)"excel_csv");
                try {
                    try (OutputStream tos = tempFile.getContent().asOutputStream();){
                        workbook.write(tos);
                    }
                    try (InputStream inputStream = tempFile.getContent().asInputStream();
                         Workbook tempWorkbook = WorkbookFactory.create((InputStream)inputStream);){
                        CSVConverterUtil csvConverterUtil = new CSVConverterUtil(tempWorkbook);
                        csvConverterUtil.convert(outputStream);
                    }
                }
                finally {
                    tempFile.delete();
                }
            }
            catch (IOException e) {
                throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.data.exporting.error"), (Throwable)e);
            }
        }
    }

    private void fillSheet(Sheet sheet) throws Exception {
        int rowNum = 0;
        this.fillHeader(sheet.createRow(rowNum++), this.optionsStrategy.getDisplayNames(), sheet);
        while (this.queryExtractor.next()) {
            Row row = sheet.createRow(rowNum);
            Object dataObject = this.queryExtractor.getCurrentRow();
            this.fillRow(dataObject, row);
            ++rowNum;
        }
    }

    private void fillRow(Object rowData, Row row) throws Exception {
        if (rowData == null) {
            throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.report.generation.failed"));
        }
        this.fillData(this.optionsStrategy.readRowData(rowData), row);
    }

    private void fillHeader(Row row, List<String> fieldNames, Sheet sheet) {
        int colNum = 0;
        for (String fieldName : fieldNames) {
            CellUtil.createCell((Row)row, (int)colNum, (String)fieldName, (CellStyle)this.cellStyles.getHeaderCellStyle());
            sheet.setColumnWidth(colNum, 5120);
            ++colNum;
        }
    }

    private void fillData(List<Object> rowValues, Row row) {
        int colNum = 0;
        for (Object value : rowValues) {
            Cell cell = row.createCell(colNum);
            DataSourceExporterUtil.setCellValue(value, cell, this.cellStyles);
            ++colNum;
        }
    }
}

