/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.export;

import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;

public class ExportCellStyles {
    private static final int COLUMN_HEADER_FONT_SIZE = 10;
    private CellStyle columnCellStyle;
    private CellStyle dateCellStyle;
    private CellStyle headerCellStyle;

    public ExportCellStyles(Workbook workbook) {
        this.columnCellStyle = workbook.createCellStyle();
        this.columnCellStyle.setWrapText(true);
        this.headerCellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setBold(true);
        font.setFontHeightInPoints((short)10);
        this.headerCellStyle.setWrapText(true);
        this.headerCellStyle.setFont(font);
        this.dateCellStyle = workbook.createCellStyle();
        this.dateCellStyle.setDataFormat(workbook.getCreationHelper().createDataFormat().getFormat("dd-mm-yyyy"));
    }

    public CellStyle getColumnCellStyle() {
        return this.columnCellStyle;
    }

    public CellStyle getDateCellStyle() {
        return this.dateCellStyle;
    }

    public CellStyle getHeaderCellStyle() {
        return this.headerCellStyle;
    }
}

