/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.export;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.runtime.data.dao.validators.HqlPropertyResolver;
import com.wavemaker.runtime.data.export.ExportField;
import com.wavemaker.runtime.data.export.ExportOptions;
import com.wavemaker.runtime.data.export.ExpressionFieldValueProvider;
import com.wavemaker.runtime.data.export.FieldInfo;
import com.wavemaker.runtime.data.export.FieldValueProvider;
import com.wavemaker.runtime.data.export.SimpleFieldValueProvider;
import com.wavemaker.runtime.data.util.JavaTypeUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ExportOptionsStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportOptionsStrategy.class);
    private List<ExportField> exportFields;

    public ExportOptionsStrategy(ExportOptions options, Class<?> entityClass) {
        this.init(options, entityClass);
    }

    public List<String> getDisplayNames() {
        return this.exportFields.stream().map(ExportField::getDisplayName).collect(Collectors.toList());
    }

    public List<Object> readRowData(Object rowData) {
        return this.exportFields.stream().map(exportField -> exportField.getValueProvider().getValue(rowData)).collect(Collectors.toList());
    }

    private void init(ExportOptions options, Class<?> entityClass) {
        List<FieldInfo> fieldInfos = options.getFields();
        if (CollectionUtils.isEmpty(fieldInfos)) {
            fieldInfos = this.includeAllFields(entityClass, "", true);
        }
        this.exportFields = fieldInfos.stream().map(fieldInfo -> this.generateExportField(entityClass, (FieldInfo)fieldInfo)).collect(Collectors.toList());
    }

    private ExportField generateExportField(Class<?> entityClass, FieldInfo fieldInfo) {
        FieldValueProvider provider;
        String displayName = this.getDisplayName(fieldInfo);
        if (StringUtils.isNotBlank((CharSequence)fieldInfo.getField())) {
            Optional<Field> fieldOptional = HqlPropertyResolver.findField(fieldInfo.getField(), entityClass);
            if (fieldOptional.isPresent()) {
                provider = new SimpleFieldValueProvider(fieldInfo.getField(), entityClass);
            } else {
                LOGGER.warn("Field: {} not present in the Entity class: {}", (Object)fieldInfo.getField(), (Object)entityClass.getName());
                provider = object -> null;
            }
        } else if (StringUtils.isNotBlank((CharSequence)fieldInfo.getExpression())) {
            provider = new ExpressionFieldValueProvider(fieldInfo.getExpression());
        } else {
            throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.no.fieldName.or.expression"));
        }
        return new ExportField(displayName, provider);
    }

    private List<FieldInfo> includeAllFields(Class<?> dataClass, String prefix, boolean includeChildren) {
        try {
            ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
            for (Field field : dataClass.getDeclaredFields()) {
                Object fieldName = field.getName();
                Class<?> type = field.getType();
                if (JavaTypeUtils.isKnownType(type)) {
                    if (StringUtils.isNotBlank((CharSequence)prefix)) {
                        fieldName = prefix + "." + (String)fieldName;
                    }
                    fieldInfos.add(new FieldInfo((String)fieldName));
                    continue;
                }
                if (!includeChildren || !JavaTypeUtils.isNotCollectionType(type)) continue;
                fieldInfos.addAll(this.includeAllFields(Class.forName(type.getName()), (String)fieldName, false));
            }
            return fieldInfos;
        }
        catch (Exception e) {
            throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.unexpected.exportOptions.generation.error"), (Throwable)e);
        }
    }

    private String getDisplayName(FieldInfo fieldInfo) {
        if (StringUtils.isBlank((CharSequence)fieldInfo.getHeader())) {
            if (StringUtils.isNotBlank((CharSequence)fieldInfo.getField())) {
                return this.capitaliseFieldName(fieldInfo.getField());
            }
            return "";
        }
        return fieldInfo.getHeader();
    }

    private String capitaliseFieldName(String fieldName) {
        String[] nestedFieldNames = fieldName.split("\\.");
        StringBuilder displayName = new StringBuilder();
        for (int i = 0; i < nestedFieldNames.length; ++i) {
            displayName.append(WordUtils.capitalize((String)nestedFieldNames[i]));
            if (i == nestedFieldNames.length - 1) continue;
            displayName.append(" ");
        }
        return displayName.toString();
    }
}

