/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.export;

import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.runtime.data.export.FieldValueProvider;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionFieldValueProvider
implements FieldValueProvider {
    private final Template template;
    private static final Logger logger = LoggerFactory.getLogger(ExpressionFieldValueProvider.class);

    public ExpressionFieldValueProvider(String expression) {
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_23);
        StringTemplateLoader templateLoader = new StringTemplateLoader();
        templateLoader.putTemplate("expression", expression);
        configuration.setTemplateLoader((TemplateLoader)templateLoader);
        configuration.setDefaultEncoding("UTF-8");
        configuration.setLocale(Locale.US);
        configuration.setAPIBuiltinEnabled(true);
        configuration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        try {
            this.template = configuration.getTemplate("expression");
        }
        catch (IOException e) {
            throw new WMRuntimeException((Throwable)e);
        }
    }

    @Override
    public Object getValue(Object object) {
        try {
            StringWriter writer = new StringWriter();
            this.template.process(object, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            logger.warn("Invalid expression: {}. Refer documentation for more information.", object);
            return "";
        }
    }
}

