/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.export;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.runtime.data.export.FieldValueProvider;
import com.wavemaker.runtime.data.util.JavaTypeUtils;
import java.beans.PropertyDescriptor;
import org.springframework.beans.BeanUtils;

public class SimpleFieldValueProvider
implements FieldValueProvider {
    private final String fieldName;
    private final Class<?> dataClass;

    public SimpleFieldValueProvider(String fieldName, Class<?> dataClass) {
        this.fieldName = fieldName;
        this.dataClass = dataClass;
    }

    @Override
    public Object getValue(Object object) {
        String[] nestedFields = this.fieldName.split("\\.");
        Object value = null;
        Object nestedRowData = object;
        Class<?> currentClass = this.dataClass;
        try {
            for (String name : nestedFields) {
                PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(currentClass, (String)name);
                Object object2 = value = nestedRowData == null ? null : propertyDescriptor.getReadMethod().invoke(nestedRowData, new Object[0]);
                if (value == null) break;
                nestedRowData = value;
                Class<?> propertyType = propertyDescriptor.getPropertyType();
                if (JavaTypeUtils.isKnownType(propertyType)) continue;
                currentClass = propertyType;
            }
            return value;
        }
        catch (Exception e) {
            throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.invalid.field.name"), (Throwable)e);
        }
    }
}

