/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.export.nativesql;

import com.wavemaker.runtime.data.export.QueryExtractor;
import com.wavemaker.runtime.data.transform.WMResultTransformer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.HashMap;

public class NativeQueryExtractor
implements QueryExtractor {
    private ResultSet resultSet;
    private WMResultTransformer resultTransformer;
    private int currentIndex;

    public NativeQueryExtractor(ResultSet resultSet, WMResultTransformer resultTransformer) {
        this.resultSet = resultSet;
        this.resultTransformer = resultTransformer;
    }

    @Override
    public boolean next() throws Exception {
        boolean hasNext = this.resultSet.next();
        ++this.currentIndex;
        return hasNext;
    }

    @Override
    public boolean isFirstRow() {
        return this.currentIndex == 1;
    }

    @Override
    public Object getCurrentRow() throws Exception {
        ResultSetMetaData metaData = this.resultSet.getMetaData();
        HashMap<String, Object> columnDataMap = new HashMap<String, Object>();
        for (int colIndex = 1; colIndex <= metaData.getColumnCount(); ++colIndex) {
            String aliasName = metaData.getColumnLabel(colIndex);
            Object value = this.resultSet.getObject(colIndex);
            columnDataMap.put(aliasName, value);
        }
        return this.resultTransformer.transformFromMap(columnDataMap);
    }
}

