/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.export.util;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class CSVConverterUtil {
    private Workbook workbook;
    private DataFormatter formatter = new DataFormatter(true);
    private FormulaEvaluator evaluator;
    private ArrayList<ArrayList<String>> csvData;
    private int maxRowWidth;
    private String separator = ",";
    private static final String DEFAULT_SEPARATOR = ",";

    public CSVConverterUtil(Workbook workbook) {
        this.workbook = workbook;
        this.csvData = new ArrayList();
        this.evaluator = this.workbook.getCreationHelper().createFormulaEvaluator();
    }

    public void convert(OutputStream outputStream) {
        try {
            this.convertToCSV();
            this.toCSV(outputStream);
        }
        catch (Exception e) {
            throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.data.exporting.csv.error"), (Throwable)e);
        }
    }

    private void convertToCSV() {
        int sheetCount = this.workbook.getNumberOfSheets();
        for (int index = 0; index < sheetCount; ++index) {
            Sheet sheet = this.workbook.getSheetAt(index);
            if (sheet.getPhysicalNumberOfRows() <= 0) continue;
            int lastRowNum = sheet.getLastRowNum();
            for (int i = 0; i <= lastRowNum; ++i) {
                Row row = sheet.getRow(i);
                this.rowToCSV(row);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toCSV(OutputStream outStream) throws IOException {
        OutputStreamWriter osWriter = new OutputStreamWriter(outStream);
        try {
            for (int i = 0; i < this.csvData.size(); ++i) {
                StringBuilder buffer = new StringBuilder();
                ArrayList<String> line = this.csvData.get(i);
                for (int j = 0; j < this.maxRowWidth; ++j) {
                    String csvLineElement;
                    if (line.size() > j && (csvLineElement = line.get(j)) != null) {
                        buffer.append(this.escapeEmbeddedCharacters(csvLineElement));
                    }
                    if (j >= this.maxRowWidth - 1) continue;
                    buffer.append(this.separator);
                }
                osWriter.write(buffer.toString().trim());
                if (i >= this.csvData.size() - 1) continue;
                osWriter.write("\n");
            }
        }
        finally {
            osWriter.flush();
            osWriter.close();
        }
    }

    private String escapeEmbeddedCharacters(String field) {
        StringBuilder builder;
        if (field.contains("\"")) {
            builder = new StringBuilder(field.replaceAll("\"", "\\\"\\\""));
            builder.insert(0, "\"");
            builder.append("\"");
        } else {
            builder = new StringBuilder(field);
            if (builder.indexOf(this.separator) > -1 || builder.indexOf("\n") > -1) {
                builder.insert(0, "\"");
                builder.append("\"");
            }
        }
        return builder.toString().trim();
    }

    private void rowToCSV(Row row) {
        ArrayList<String> csvLine = new ArrayList<String>();
        if (row != null) {
            int lastCellNum = row.getLastCellNum();
            for (int i = 0; i <= lastCellNum; ++i) {
                Cell cell = row.getCell(i);
                if (cell == null) {
                    csvLine.add("");
                    continue;
                }
                if (cell.getCellType() != CellType.FORMULA) {
                    csvLine.add(this.formatter.formatCellValue(cell));
                    continue;
                }
                csvLine.add(this.formatter.formatCellValue(cell, this.evaluator));
            }
            if (lastCellNum > this.maxRowWidth) {
                this.maxRowWidth = lastCellNum;
            }
        }
        this.csvData.add(csvLine);
    }
}

