/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.export.util;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.runtime.data.export.ExportCellStyles;
import com.wavemaker.runtime.data.export.util.ImageUtils;
import com.wavemaker.runtime.data.model.JavaType;
import com.wavemaker.runtime.data.util.JavaTypeUtils;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.Date;
import java.util.Optional;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.hibernate.ScrollableResults;
import org.hibernate.internal.AbstractScrollableResults;
import org.springframework.util.ReflectionUtils;

public class DataSourceExporterUtil {
    private DataSourceExporterUtil() {
    }

    public static ResultSet constructResultSet(ScrollableResults scroll) {
        try {
            Method resultSetMethod = AbstractScrollableResults.class.getDeclaredMethod("getResultSet", new Class[0]);
            ReflectionUtils.makeAccessible((Method)resultSetMethod);
            return (ResultSet)resultSetMethod.invoke((Object)scroll, new Object[0]);
        }
        catch (Exception e) {
            throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.failed.to.fetch.resultset"), (Throwable)e);
        }
    }

    public static void setCellValue(Object data, Cell cell, ExportCellStyles cellStyles) {
        try {
            cell.setCellStyle(cellStyles.getColumnCellStyle());
            if (data != null) {
                Optional<JavaType> typeOptional = JavaTypeUtils.fromClassName(data.getClass().getCanonicalName());
                if (typeOptional.isPresent()) {
                    switch (typeOptional.get()) {
                        case BLOB: {
                            ImageUtils.addImageToSheet((byte[])data, cell);
                            break;
                        }
                        case DATE: {
                            cell.setCellValue((Date)((java.sql.Date)data));
                            cell.setCellStyle(cellStyles.getDateCellStyle());
                            break;
                        }
                        case INTEGER: 
                        case SHORT: 
                        case LONG: 
                        case BIG_INTEGER: 
                        case DOUBLE: 
                        case FLOAT: 
                        case BIG_DECIMAL: {
                            cell.setCellType(CellType.NUMERIC);
                            cell.setCellValue(((Double)JavaType.DOUBLE.fromString(data.toString())).doubleValue());
                            break;
                        }
                        default: {
                            cell.setCellValue(data.toString());
                            break;
                        }
                    }
                } else {
                    cell.setCellValue(data.toString());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while exporting data to report", e);
        }
    }
}

