/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.export.util;

public class ImageUnitsConverter {
    public static final int TOTAL_COLUMN_COORDINATE_POSITIONS = 1023;
    public static final int TOTAL_ROW_COORDINATE_POSITIONS = 255;
    public static final int PIXELS_PER_INCH = 96;
    public static final double PIXELS_PER_MILLIMETRES = 3.78;
    public static final double POINTS_PER_MILLIMETRE = 2.83;
    public static final double CELL_BORDER_WIDTH_MILLIMETRES = 2.0;
    public static final short EXCEL_COLUMN_WIDTH_FACTOR = 256;
    public static final int UNIT_OFFSET_LENGTH = 7;
    private static final int[] UNIT_OFFSET_MAP = new int[]{0, 36, 73, 109, 146, 182, 219};

    private ImageUnitsConverter() {
    }

    public static short pixel2WidthUnits(int pxs) {
        short widthUnits = (short)(256 * (pxs / 7));
        widthUnits = (short)(widthUnits + UNIT_OFFSET_MAP[pxs % 7]);
        return widthUnits;
    }

    public static int widthUnits2Pixel(short widthUnits) {
        int pixels = widthUnits / 256 * 7;
        int offsetWidthUnits = widthUnits % 256;
        return pixels += Math.round((float)offsetWidthUnits / 36.57143f);
    }

    public static double widthUnits2Millimetres(short widthUnits) {
        return (double)ImageUnitsConverter.widthUnits2Pixel(widthUnits) / 3.78;
    }

    public static int millimetres2WidthUnits(double millimetres) {
        return ImageUnitsConverter.pixel2WidthUnits((int)(millimetres * 3.78));
    }

    public static class ClientAnchorDetail {
        private int fromIndex;
        private int toIndex;
        private int inset;

        public ClientAnchorDetail(int fromIndex, int toIndex, int inset) {
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
            this.inset = inset;
        }

        public int getFromIndex() {
            return this.fromIndex;
        }

        public int getToIndex() {
            return this.toIndex;
        }

        public int getInset() {
            return this.inset;
        }
    }
}

