/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.export.util;

import com.wavemaker.runtime.data.export.util.ImageUnitsConverter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class ImageUtils {
    private static final int EXPAND_ROW = 1;
    private static final int EXPAND_COLUMN = 2;
    private static final int EXPAND_ROW_AND_COLUMN = 3;
    private static final int OVERLAY_ROW_AND_COLUMN = 7;
    private static final int EMU_PER_MM = 36000;

    private ImageUtils() {
    }

    public static void addImageToSheet(byte[] image, Cell cell) {
        Row row = cell.getRow();
        Sheet sheet = row.getSheet();
        int resizeBehaviour = 3;
        int reqImageWidthMM = 20;
        int reqImageHeightMM = 30;
        ImageUnitsConverter.ClientAnchorDetail colClientAnchorDetail = ImageUtils.fitImageToColumns(sheet, cell.getColumnIndex(), reqImageWidthMM, resizeBehaviour);
        ImageUnitsConverter.ClientAnchorDetail rowClientAnchorDetail = ImageUtils.fitImageToRows(sheet, row.getRowNum(), reqImageHeightMM, resizeBehaviour);
        if (colClientAnchorDetail != null && rowClientAnchorDetail != null) {
            ClientAnchor anchor = ImageUtils.getClientAnchor(sheet, colClientAnchorDetail, rowClientAnchorDetail);
            int index = sheet.getWorkbook().addPicture(image, 5);
            Drawing drawing = sheet.createDrawingPatriarch();
            drawing.createPicture(anchor, index);
        }
    }

    private static ImageUnitsConverter.ClientAnchorDetail fitImageToColumns(Sheet sheet, int colNumber, double reqImageWidthMM, int resizeBehaviour) {
        ImageUnitsConverter.ClientAnchorDetail colClientAnchorDetail = null;
        double colWidthMM = ImageUnitsConverter.widthUnits2Millimetres((short)sheet.getColumnWidth(colNumber));
        if (colWidthMM < reqImageWidthMM) {
            if (resizeBehaviour == 2 || resizeBehaviour == 3) {
                sheet.setColumnWidth(colNumber, ImageUnitsConverter.millimetres2WidthUnits(reqImageWidthMM));
                int pictureWidthCoordinates = (int)reqImageWidthMM * 36000;
                colClientAnchorDetail = new ImageUnitsConverter.ClientAnchorDetail(colNumber, colNumber, pictureWidthCoordinates);
            } else if (resizeBehaviour == 7 || resizeBehaviour == 1) {
                colClientAnchorDetail = ImageUtils.calculateColumnLocation(sheet, colNumber, reqImageWidthMM);
            }
        } else {
            int pictureWidthCoordinates = (int)reqImageWidthMM * 36000;
            colClientAnchorDetail = new ImageUnitsConverter.ClientAnchorDetail(colNumber, colNumber, pictureWidthCoordinates);
        }
        return colClientAnchorDetail;
    }

    private static ImageUnitsConverter.ClientAnchorDetail fitImageToRows(Sheet sheet, int rowNumber, double reqImageHeightMM, int resizeBehaviour) {
        double rowHeightMM;
        ImageUnitsConverter.ClientAnchorDetail rowClientAnchorDetail = null;
        Row row = sheet.getRow(rowNumber);
        if (row == null) {
            row = sheet.createRow(rowNumber);
        }
        if ((rowHeightMM = (double)row.getHeightInPoints() / 2.83) < reqImageHeightMM) {
            if (resizeBehaviour == 1 || resizeBehaviour == 3) {
                row.setHeightInPoints((float)(reqImageHeightMM * 2.83));
                int pictureHeightCoordinates = (int)(reqImageHeightMM * 36000.0);
                rowClientAnchorDetail = new ImageUnitsConverter.ClientAnchorDetail(rowNumber, rowNumber, pictureHeightCoordinates);
            } else if (resizeBehaviour == 7 || resizeBehaviour == 2) {
                rowClientAnchorDetail = ImageUtils.calculateRowLocation(sheet, rowNumber, reqImageHeightMM);
            }
        } else {
            int pictureHeightCoordinates = (int)(reqImageHeightMM * 36000.0);
            rowClientAnchorDetail = new ImageUnitsConverter.ClientAnchorDetail(rowNumber, rowNumber, pictureHeightCoordinates);
        }
        return rowClientAnchorDetail;
    }

    private static ImageUnitsConverter.ClientAnchorDetail calculateColumnLocation(Sheet sheet, int startingColumn, double reqImageWidthMM) {
        double totalWidthMM = 0.0;
        double colWidthMM = 0.0;
        int toColumn = startingColumn;
        while (totalWidthMM < reqImageWidthMM) {
            colWidthMM = ImageUnitsConverter.widthUnits2Millimetres((short)sheet.getColumnWidth(toColumn));
            totalWidthMM += colWidthMM + 2.0;
            ++toColumn;
        }
        return ImageUtils.getClientAnchorDetail(startingColumn, reqImageWidthMM, totalWidthMM, colWidthMM, --toColumn);
    }

    private static ImageUnitsConverter.ClientAnchorDetail calculateRowLocation(Sheet sheet, int startingRow, double reqImageHeightMM) {
        double rowHeightMM = 0.0;
        double totalRowHeightMM = 0.0;
        int toRow = startingRow;
        while (totalRowHeightMM < reqImageHeightMM) {
            Row row = sheet.getRow(toRow);
            if (row == null) {
                row = sheet.createRow(toRow);
            }
            rowHeightMM = (double)row.getHeightInPoints() / 2.83;
            totalRowHeightMM += rowHeightMM;
            ++toRow;
        }
        return ImageUtils.getClientAnchorDetail(startingRow, reqImageHeightMM, rowHeightMM, totalRowHeightMM, --toRow);
    }

    private static ImageUnitsConverter.ClientAnchorDetail getClientAnchorDetail(int fromIndex, double requiredDimension, double indexDimension, double totalDimension, int toIndex) {
        ImageUnitsConverter.ClientAnchorDetail clientAnchorDetail;
        if ((int)totalDimension == (int)requiredDimension) {
            clientAnchorDetail = new ImageUnitsConverter.ClientAnchorDetail(fromIndex, toIndex, (int)requiredDimension * 36000);
        } else {
            double overlapMM = requiredDimension - (totalDimension - indexDimension);
            if (overlapMM < 0.0) {
                overlapMM = 0.0;
            }
            int inset = (int)overlapMM * 36000;
            clientAnchorDetail = new ImageUnitsConverter.ClientAnchorDetail(fromIndex, toIndex, inset);
        }
        return clientAnchorDetail;
    }

    private static ClientAnchor getClientAnchor(Sheet sheet, ImageUnitsConverter.ClientAnchorDetail colClientAnchorDetail, ImageUnitsConverter.ClientAnchorDetail rowClientAnchorDetail) {
        ClientAnchor anchor = sheet.getWorkbook().getCreationHelper().createClientAnchor();
        anchor.setDx1(0);
        anchor.setDy1(0);
        anchor.setDx2(colClientAnchorDetail.getInset());
        anchor.setDy2(rowClientAnchorDetail.getInset());
        anchor.setCol1(colClientAnchorDetail.getFromIndex());
        anchor.setRow1(rowClientAnchorDetail.getFromIndex());
        anchor.setCol2(colClientAnchorDetail.getToIndex());
        anchor.setRow2(rowClientAnchorDetail.getToIndex());
        anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
        return anchor;
    }
}

