/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.expression;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Restrictions;

public enum JoinType {
    AND("and"){

        @Override
        public LogicalExpression criterion(Criterion lhs, Criterion rhs) {
            return Restrictions.and((Criterion)lhs, (Criterion)rhs);
        }
    }
    ,
    OR("or"){

        @Override
        public LogicalExpression criterion(Criterion lhs, Criterion rhs) {
            return Restrictions.or((Criterion)lhs, (Criterion)rhs);
        }
    };

    static Map<String, JoinType> nameVsJoinType;
    private String name;

    private JoinType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract LogicalExpression criterion(Criterion var1, Criterion var2);

    public static JoinType valueFor(String typeName) {
        return nameVsJoinType.get(typeName.toLowerCase());
    }

    static {
        nameVsJoinType = new HashMap<String, JoinType>();
        for (JoinType joinType : JoinType.values()) {
            nameVsJoinType.put(joinType.getName(), joinType);
        }
    }
}

