/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.expression;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.runtime.data.expression.Criteria;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public enum Type implements Criteria
{
    STARTING_WITH("startswith"){

        @Override
        public Criterion criterion(String name, Object value) {
            return Restrictions.ilike((String)name, (String)String.valueOf(value), (MatchMode)MatchMode.START);
        }
    }
    ,
    ENDING_WITH("endswith"){

        @Override
        public Criterion criterion(String name, Object value) {
            return Restrictions.ilike((String)name, (String)String.valueOf(value), (MatchMode)MatchMode.END);
        }
    }
    ,
    CONTAINING("containing"){

        @Override
        public Criterion criterion(String name, Object value) {
            return Restrictions.ilike((String)name, (String)String.valueOf(value), (MatchMode)MatchMode.ANYWHERE);
        }
    }
    ,
    EQUALS("="){

        @Override
        public Criterion criterion(String name, Object value) {
            SimpleExpression criterion;
            if (value == null) {
                throw new IllegalArgumentException("Equals expression should not have null value, either collection or array or primitive values supported.");
            }
            if (value instanceof Collection) {
                Collection values = (Collection)value;
                if (values.isEmpty()) {
                    throw new IllegalArgumentException("Equals expression should have a collection/array of values with at-least one entry.");
                }
                criterion = Restrictions.in((String)name, (Collection)values);
            } else if (value.getClass().isArray()) {
                Object[] values = (Object[])value;
                if (values.length == 0) {
                    throw new IllegalArgumentException("Equals expression should have a collection/array of values with at-least one entry.");
                }
                criterion = Restrictions.in((String)name, (Object[])values);
            } else {
                criterion = Restrictions.eq((String)name, (Object)value);
            }
            return criterion;
        }
    }
    ,
    NOT_EQUALS("!="){

        @Override
        public Criterion criterion(String name, Object value) {
            return Restrictions.ne((String)name, (Object)value);
        }
    }
    ,
    BETWEEN("between"){

        @Override
        public Criterion criterion(String name, Object value) {
            Criterion criterion;
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                if (collection.size() != 2) {
                    throw new IllegalArgumentException("Between expression should have a collection/array of values with just two entries.");
                }
                Iterator iterator = collection.iterator();
                criterion = Restrictions.between((String)name, iterator.next(), iterator.next());
            } else if (value.getClass().isArray()) {
                Object[] array = (Object[])value;
                if (array.length != 2) {
                    throw new IllegalArgumentException("Between expression should have a array/array of values with just two entries.");
                }
                criterion = Restrictions.between((String)name, (Object)array[0], (Object)array[1]);
            } else {
                throw new IllegalArgumentException("Between expression should have a collection/array of values with just two entries.");
            }
            return criterion;
        }
    }
    ,
    LESS_THAN("<"){

        @Override
        public Criterion criterion(String name, Object value) {
            return Restrictions.lt((String)name, (Object)value);
        }
    }
    ,
    LESS_THAN_OR_EQUALS("<="){

        @Override
        public Criterion criterion(String name, Object value) {
            return Restrictions.le((String)name, (Object)value);
        }
    }
    ,
    GREATER_THAN(">"){

        @Override
        public Criterion criterion(String name, Object value) {
            return Restrictions.gt((String)name, (Object)value);
        }
    }
    ,
    GREATER_THAN_OR_EQUALS(">="){

        @Override
        public Criterion criterion(String name, Object value) {
            return Restrictions.ge((String)name, (Object)value);
        }
    }
    ,
    NULL("null"){

        @Override
        public Criterion criterion(String name, Object value) {
            return Restrictions.isNull((String)name);
        }
    }
    ,
    EMPTY("empty"){

        @Override
        public Criterion criterion(String name, Object value) {
            return Restrictions.eq((String)name, (Object)"");
        }
    }
    ,
    LIKE("like"){

        @Override
        public Criterion criterion(String name, Object value) {
            return Restrictions.like((String)name, (Object)value);
        }
    }
    ,
    IN("in"){

        @Override
        public Criterion criterion(String name, Object value) {
            if (value instanceof Collection) {
                return Restrictions.in((String)name, (Collection)((Collection)value));
            }
            throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.unexpected.value.type"), new Object[]{value.getClass()});
        }
    }
    ,
    NULL_OR_EMPTY("nullorempty"){

        @Override
        public Criterion criterion(String name, Object value) {
            SimpleExpression emptyValueCriterion = Restrictions.eq((String)name, (Object)"");
            Criterion nullValueCriterion = Restrictions.isNull((String)name);
            return Restrictions.or((Criterion)emptyValueCriterion, (Criterion)nullValueCriterion);
        }
    }
    ,
    IS("is"){

        @Override
        public Criterion criterion(String name, Object value) {
            String castedValue = (String)value;
            if ("null".equalsIgnoreCase(castedValue)) {
                return NULL.criterion(name, value);
            }
            if ("notnull".equalsIgnoreCase(castedValue)) {
                return Restrictions.not((Criterion)NULL.criterion(name, value));
            }
            if ("nullorempty".equalsIgnoreCase(castedValue)) {
                return NULL_OR_EMPTY.criterion(name, value);
            }
            if ("empty".equalsIgnoreCase(castedValue)) {
                return EMPTY.criterion(name, value);
            }
            throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.invalid.IS.operator.value"), new Object[]{value.getClass()});
        }
    };

    static Map<String, Type> nameVsType;
    private String name;

    private Type(String name) {
        this.name = name;
    }

    public static Type valueFor(String typeName) {
        return nameVsType.get(typeName.toLowerCase());
    }

    public String getName() {
        return this.name;
    }

    static {
        nameVsType = new HashMap<String, Type>();
        for (Type type : Type.values()) {
            nameVsType.put(type.getName(), type);
        }
    }
}

