/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.filter;

import com.wavemaker.runtime.data.expression.Type;
import com.wavemaker.runtime.data.filter.QueryInterceptor;
import com.wavemaker.runtime.data.filter.WMQueryInfo;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LegacyQueryFilterInterceptor
implements QueryInterceptor {
    private static final String LEGACY_QUERY_EXPRESSION = "([\\w]+)[\\s]+(startswith|endswith|containing)[\\s][\"']([^']+)+([\"'])";
    private static Pattern legacyQueryPattern = Pattern.compile("([\\w]+)[\\s]+(startswith|endswith|containing)[\\s][\"']([^']+)+([\"'])");
    private static final String WILDCARD_ENTRY = "%";
    private static final byte FIELD_NAME = 1;
    private static final byte EXPRESSION = 2;
    private static final byte VALUE = 3;

    @Override
    public void intercept(WMQueryInfo queryInfo, Class<?> entity) {
        queryInfo.setQuery(LegacyQueryFilterInterceptor.replaceExpressionWithHQL(queryInfo.getQuery()));
    }

    static String replaceExpressionWithHQL(String query) {
        Matcher matcher = legacyQueryPattern.matcher(query);
        StringBuffer hqlQuery = new StringBuffer();
        while (matcher.find()) {
            Object value = "";
            switch (Type.valueFor(matcher.group(2))) {
                case STARTING_WITH: {
                    value = matcher.group(3) + WILDCARD_ENTRY;
                    break;
                }
                case ENDING_WITH: {
                    value = WILDCARD_ENTRY + matcher.group(3);
                    break;
                }
                case CONTAINING: {
                    value = WILDCARD_ENTRY + matcher.group(3) + WILDCARD_ENTRY;
                    break;
                }
            }
            matcher.appendReplacement(hqlQuery, matcher.group(1) + " like '" + (String)value + "'");
        }
        matcher.appendTail(hqlQuery);
        return hqlQuery.toString();
    }
}

