/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.filter;

import com.wavemaker.runtime.data.filter.QueryInterceptor;
import com.wavemaker.runtime.data.filter.WMQueryInfo;
import com.wavemaker.runtime.data.filter.WMQueryParamInfo;
import com.wavemaker.runtime.data.filter.parser.HqlFilterPropertyResolverImpl;
import com.wavemaker.runtime.data.filter.parser.HqlParser;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class WMQueryGrammarInterceptor
implements QueryInterceptor {
    private static final Map<String, String> paramValueReplacements = new HashMap<String, String>();

    @Override
    public void intercept(WMQueryInfo queryInfo, Class<?> entity) {
        HqlFilterPropertyResolverImpl resolver = new HqlFilterPropertyResolverImpl(entity);
        WMQueryInfo parsedQuery = HqlParser.getInstance().parse(queryInfo.getQuery(), resolver);
        this.removeEscapeCharactersFromParameterValues(parsedQuery);
        queryInfo.setQuery(parsedQuery.getQuery());
        queryInfo.getParameters().putAll(parsedQuery.getParameters());
    }

    private void removeEscapeCharactersFromParameterValues(WMQueryInfo wmQueryInfo) {
        for (WMQueryParamInfo param : wmQueryInfo.getParameters().values()) {
            for (Map.Entry<String, String> paramValueReplacement : paramValueReplacements.entrySet()) {
                String paramValue = Objects.toString(param.getValue(), "");
                if (!paramValue.contains(paramValueReplacement.getKey())) continue;
                param.setValue(paramValue.replaceAll(paramValueReplacement.getKey(), paramValueReplacement.getValue()));
            }
        }
    }

    static {
        paramValueReplacements.put("''", "'");
    }
}

