/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.filter;

import com.wavemaker.runtime.data.dao.query.types.wmql.WMQLTypeHelper;
import com.wavemaker.runtime.data.filter.WMQueryParamInfo;
import com.wavemaker.runtime.data.model.JavaType;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class WMQueryInfo {
    private String query;
    private Map<String, WMQueryParamInfo> parameters;

    public WMQueryInfo(String query) {
        this.query = query;
        this.parameters = new HashMap<String, WMQueryParamInfo>();
    }

    public WMQueryInfo(String query, Map<String, WMQueryParamInfo> parameters) {
        this.query = query;
        this.parameters = parameters;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Map<String, WMQueryParamInfo> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, WMQueryParamInfo> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(String key, Object value) {
        this.parameters.put(key, new WMQueryParamInfo(value));
    }

    public void addParameter(String key, WMQueryParamInfo wmQueryParamInfo) {
        this.parameters.put(key, wmQueryParamInfo);
    }

    public Map<String, Object> getParameterValueMap(WMQLTypeHelper wmqlTypeHelper) {
        return this.parameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, m -> {
            WMQueryParamInfo paramInfo = (WMQueryParamInfo)m.getValue();
            Object value = paramInfo.getValue();
            JavaType javaType = paramInfo.getJavaType();
            if (javaType != null) {
                javaType = wmqlTypeHelper.aliasFor(javaType);
                value = javaType.fromString(String.valueOf(value));
            }
            return value;
        }));
    }

    public String toString() {
        return "WMQueryInfo{query='" + this.query + "', parameters=" + this.parameters + "}";
    }
}

