/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.filter.parser;

import com.wavemaker.runtime.data.filter.parser.HqlFilterPropertyResolver;
import com.wavemaker.runtime.data.filter.parser.HqlParserContext;
import com.wavemaker.runtime.data.filter.parser.antlr4.HqlFilterParser;
import com.wavemaker.runtime.data.model.JavaType;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;

public class HqlExpressionParser {
    private static final List<Integer> valueTerminals = Arrays.asList(18, 19, 14, 17);
    private static final List<Class<?>> nullContexts = Arrays.asList(HqlFilterParser.IsNullContext.class, HqlFilterParser.IsNotNullContext.class);
    private static final String PARAMETER_PREFIX = "wm_parsed_param";
    private ParseTree condition;
    private HqlFilterParser.KeyContext keyContext;

    public HqlExpressionParser(HqlFilterParser.ExpressionContext expression) {
        this.keyContext = expression.key();
        this.condition = expression.condition();
    }

    public void parse(HqlParserContext hqlParserContext) {
        String key = this.keyContext.getToken(20, 0).getText();
        HqlFilterPropertyResolver propertyResolver = hqlParserContext.getHqlFilterPropertyResolver();
        Field keyField = propertyResolver.findField(key);
        JavaType keyJavaType = null;
        if (!nullContexts.contains(this.condition.getChild(0).getClass())) {
            keyJavaType = propertyResolver.findJavaType(keyField);
        }
        hqlParserContext.appendQuery(this.keyContext.getText());
        this.resolveCondition(this.condition, hqlParserContext, keyJavaType);
    }

    private void resolveCondition(ParseTree node, HqlParserContext hqlParserContext, JavaType keyJavaType) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            ParseTree child = node.getChild(i);
            if (child instanceof TerminalNodeImpl) {
                TerminalNodeImpl terminalNode = (TerminalNodeImpl)child;
                if (valueTerminals.contains(terminalNode.getSymbol().getType())) {
                    String value = terminalNode.getText();
                    if (!"null".equalsIgnoreCase(value)) {
                        value = value.replaceAll("^'|'$", "");
                        String placeHolderKey = this.getNextPlaceHolderKey(hqlParserContext);
                        hqlParserContext.addParameter(placeHolderKey, value, keyJavaType);
                        hqlParserContext.appendQuery(":" + placeHolderKey);
                        continue;
                    }
                    hqlParserContext.appendQuery(value);
                    continue;
                }
                hqlParserContext.appendQuery(child.getText());
                continue;
            }
            this.resolveCondition(child, hqlParserContext, keyJavaType);
        }
    }

    private String getNextPlaceHolderKey(HqlParserContext hqlParserContext) {
        return PARAMETER_PREFIX + hqlParserContext.getParameters().size();
    }
}

