/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.filter.parser;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.runtime.data.dao.validators.HqlPropertyResolver;
import com.wavemaker.runtime.data.exception.HqlGrammarException;
import com.wavemaker.runtime.data.filter.parser.HqlFilterPropertyResolver;
import com.wavemaker.runtime.data.model.JavaType;
import com.wavemaker.runtime.data.util.JavaTypeUtils;
import java.lang.reflect.Field;
import java.util.Optional;

public class HqlFilterPropertyResolverImpl
implements HqlFilterPropertyResolver {
    private Class<?> entity;

    public HqlFilterPropertyResolverImpl(Class<?> entity) {
        this.entity = entity;
    }

    @Override
    public Field findField(String propertyKey) {
        Optional<Field> optionalField = HqlPropertyResolver.findField(propertyKey, this.entity);
        if (!optionalField.isPresent()) {
            throw new HqlGrammarException(MessageResource.create((String)"Property {0} in the class {1} is not valid."), propertyKey, this.entity.getName());
        }
        return optionalField.get();
    }

    @Override
    public JavaType findJavaType(Field field) {
        JavaType javaType = JavaTypeUtils.fromClassName(field.getType().getName()).orElse(null);
        if (javaType == null) {
            throw new HqlGrammarException(MessageResource.create((String)"The property {0} in the entity {1} is not a comparable data type."), field, this.entity.getName());
        }
        return javaType;
    }
}

