/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.filter.parser;

import com.wavemaker.runtime.data.filter.WMQueryInfo;
import com.wavemaker.runtime.data.filter.parser.HqlExpressionParser;
import com.wavemaker.runtime.data.filter.parser.HqlFilterPropertyResolver;
import com.wavemaker.runtime.data.filter.parser.HqlParserContext;
import com.wavemaker.runtime.data.filter.parser.WMHqlAntlrErrorListner;
import com.wavemaker.runtime.data.filter.parser.antlr4.HqlFilterLexer;
import com.wavemaker.runtime.data.filter.parser.antlr4.HqlFilterParser;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;

public class HqlParser {
    private static HqlParser instance;

    public static HqlParser getInstance() {
        return instance == null ? (instance = new HqlParser()) : instance;
    }

    public WMQueryInfo parse(String expression, HqlFilterPropertyResolver resolver) {
        HqlParserContext hqlParserContext = new HqlParserContext(resolver);
        ParseTree rootNode = this.getRootNode(expression);
        this.parse(rootNode, hqlParserContext);
        return hqlParserContext.toWMQueryInfo();
    }

    private ParseTree getRootNode(String expression) {
        ANTLRInputStream in = new ANTLRInputStream(expression);
        HqlFilterLexer lexer = new HqlFilterLexer((CharStream)in);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new WMHqlAntlrErrorListner());
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        HqlFilterParser parser = new HqlFilterParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new WMHqlAntlrErrorListner());
        HqlFilterParser.WhereClauseContext query = parser.whereClause();
        return query.logicalExpression();
    }

    private void parse(ParseTree rule, HqlParserContext hqlParserContext) {
        for (int i = 0; i < rule.getChildCount(); ++i) {
            ParseTree child = rule.getChild(i);
            if (child instanceof HqlFilterParser.ExpressionContext) {
                HqlFilterParser.ExpressionContext expression = (HqlFilterParser.ExpressionContext)child;
                HqlExpressionParser expressionResolver = new HqlExpressionParser(expression);
                expressionResolver.parse(hqlParserContext);
                continue;
            }
            if (child instanceof TerminalNodeImpl) {
                hqlParserContext.appendQuery(child.getText());
                continue;
            }
            this.parse(child, hqlParserContext);
        }
    }
}

