/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.hql;

import com.wavemaker.runtime.data.filter.LegacyQueryFilterInterceptor;
import com.wavemaker.runtime.data.filter.QueryInterceptor;
import com.wavemaker.runtime.data.filter.WMQueryGrammarInterceptor;
import com.wavemaker.runtime.data.filter.WMQueryInfo;
import com.wavemaker.runtime.data.filter.WMQueryParamInfo;
import com.wavemaker.runtime.data.periods.PeriodClause;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public abstract class QueryBuilder<T extends QueryBuilder> {
    private static final QueryInterceptor legacyQueryFilterInterceptor = new LegacyQueryFilterInterceptor();
    private static final QueryInterceptor wmQueryGrammarInterceptor = new WMQueryGrammarInterceptor();
    protected final Class<?> entityClass;
    private final List<QueryInterceptor> interceptors;
    private List<PeriodClause> periodClauses = new ArrayList<PeriodClause>(2);
    private Map<String, Object> filterConditions = new HashMap<String, Object>();
    private String filter;

    public QueryBuilder(Class<?> entityClass) {
        this.entityClass = entityClass;
        this.interceptors = new ArrayList<QueryInterceptor>();
        this.interceptors.add(legacyQueryFilterInterceptor);
        this.interceptors.add(wmQueryGrammarInterceptor);
    }

    public T withPeriodClauses(List<PeriodClause> periodClauses) {
        this.periodClauses.addAll(periodClauses);
        return (T)this;
    }

    public T withPeriodClause(PeriodClause periodClause) {
        this.periodClauses.add(periodClause);
        return (T)this;
    }

    public T withFilterConditions(Map<String, Object> filterConditions) {
        this.filterConditions.putAll(filterConditions);
        return (T)this;
    }

    public T withFilterCondition(String fieldName, Object value) {
        this.filterConditions.put(fieldName, value);
        return (T)this;
    }

    public T withFilter(String filter) {
        this.filter = filter;
        return (T)this;
    }

    protected String generateFromClause(Map<String, WMQueryParamInfo> parameters, boolean updateDelete) {
        StringBuilder builder = new StringBuilder();
        if (!updateDelete) {
            builder.append("from ");
        }
        builder.append(this.entityClass.getCanonicalName()).append(" ");
        this.periodClauses.stream().map(PeriodClause::asWMQueryClause).forEach(queryInfo -> {
            builder.append("for ");
            if (updateDelete) {
                builder.append("portion of ");
            }
            builder.append(queryInfo.getQuery()).append(" ");
            parameters.putAll(queryInfo.getParameters());
        });
        return builder.toString();
    }

    protected String generateWhereClause(Map<String, WMQueryParamInfo> parameters) {
        StringBuilder builder = new StringBuilder();
        if (!this.filterConditions.isEmpty() || StringUtils.isNotBlank((CharSequence)this.filter)) {
            builder.append("where ");
            builder.append(this.filterConditions.entrySet().stream().map(entry -> ImmutablePair.of((Object)entry, (Object)("wm_filter_" + (String)entry.getKey()))).peek(pair -> parameters.put((String)pair.getRight(), new WMQueryParamInfo(((Map.Entry)pair.getLeft()).getValue()))).map(pair -> (String)((Map.Entry)pair.getLeft()).getKey() + " = :" + (String)pair.getRight()).collect(Collectors.joining(" and ", " ", " ")));
            if (StringUtils.isNotBlank((CharSequence)this.filter)) {
                WMQueryInfo queryInfo = this.interceptFilter(this.filter);
                if (!this.filterConditions.isEmpty()) {
                    builder.append("and ");
                }
                builder.append(queryInfo.getQuery()).append(" ");
                parameters.putAll(queryInfo.getParameters());
            }
        }
        return builder.toString();
    }

    private WMQueryInfo interceptFilter(String filter) {
        WMQueryInfo queryInfo = new WMQueryInfo(filter);
        for (QueryInterceptor interceptor : this.interceptors) {
            interceptor.intercept(queryInfo, this.entityClass);
        }
        return queryInfo;
    }
}

