/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.hql;

import com.wavemaker.runtime.data.filter.WMQueryInfo;
import com.wavemaker.runtime.data.filter.WMQueryParamInfo;
import com.wavemaker.runtime.data.hql.QueryBuilder;
import com.wavemaker.runtime.data.model.Aggregation;
import com.wavemaker.runtime.data.model.AggregationInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SelectQueryBuilder
extends QueryBuilder<SelectQueryBuilder> {
    private List<String> fields;
    private String distinctField;
    private List<String> groupByFields;
    private List<Aggregation> aggregations;

    public SelectQueryBuilder(Class<?> entityClass) {
        super(entityClass);
    }

    public static SelectQueryBuilder newBuilder(Class<?> entity) {
        return new SelectQueryBuilder(entity);
    }

    public SelectQueryBuilder withFields(List<String> fields) {
        this.fields = fields;
        return this;
    }

    public SelectQueryBuilder withDistinctFields(String distinctField) {
        this.distinctField = distinctField;
        return this;
    }

    public SelectQueryBuilder withGroupByFields(List<String> groupByFields) {
        this.groupByFields = groupByFields;
        return this;
    }

    public SelectQueryBuilder withAggregations(List<Aggregation> aggregations) {
        this.aggregations = aggregations;
        return this;
    }

    public SelectQueryBuilder withAggregationInfo(AggregationInfo aggregationInfo) {
        this.withGroupByFields(aggregationInfo.getGroupByFields()).withAggregations(aggregationInfo.getAggregations()).withFilter(aggregationInfo.getFilter());
        return this;
    }

    public WMQueryInfo build() {
        StringBuilder builder = new StringBuilder();
        HashMap<String, WMQueryParamInfo> parameters = new HashMap<String, WMQueryParamInfo>();
        String projections = this.generateProjections();
        if (StringUtils.isNotBlank((CharSequence)projections)) {
            builder.append("select ").append(projections).append(" ");
        }
        builder.append(this.generateFromClause(parameters, false));
        builder.append(this.generateWhereClause(parameters));
        if (CollectionUtils.isNotEmpty(this.groupByFields)) {
            builder.append("group by ").append(StringUtils.join(this.groupByFields, (String)",")).append(" ");
        }
        return new WMQueryInfo(builder.toString(), parameters);
    }

    public Optional<WMQueryInfo> buildCountQuery() {
        Optional<WMQueryInfo> result = Optional.empty();
        if (CollectionUtils.isEmpty(this.groupByFields)) {
            HashMap<String, WMQueryParamInfo> parameters = new HashMap<String, WMQueryParamInfo>();
            String countQuery = "select count(*) " + this.generateFromClause(parameters, false) + this.generateWhereClause(parameters);
            result = Optional.of(new WMQueryInfo(countQuery, parameters));
        }
        return result;
    }

    private String generateProjections() {
        ArrayList<Object> projections = new ArrayList<Object>();
        if (StringUtils.isNotEmpty((CharSequence)this.distinctField)) {
            projections.add("distinct(" + this.distinctField + ") as " + this.cleanAlias(this.distinctField));
        }
        if (CollectionUtils.isNotEmpty(this.fields)) {
            projections.addAll(this.fields);
        }
        if (CollectionUtils.isNotEmpty(this.groupByFields)) {
            for (String field : this.groupByFields) {
                projections.add(field + " as " + this.cleanAlias(field));
            }
        }
        if (CollectionUtils.isNotEmpty(this.aggregations)) {
            for (Aggregation aggregation : this.aggregations) {
                projections.add(aggregation.asSelection());
            }
        }
        return StringUtils.join(projections, (String)",");
    }

    private String cleanAlias(String alias) {
        return alias.replaceAll("\\.", "\\$");
    }
}

