/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.interceptors;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.runtime.commons.variable.Scope;
import com.wavemaker.runtime.data.interceptors.InterceptorContext;
import com.wavemaker.runtime.data.replacers.EntityValueReplacer;
import com.wavemaker.runtime.data.replacers.ListenerContext;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import org.hibernate.EmptyInterceptor;
import org.hibernate.type.Type;

public class WMEntityInterceptor
extends EmptyInterceptor {
    private InterceptorContext context = new InterceptorContext();

    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        EntityValueReplacer valueReplacer = this.context.getEntityValueOverrider(entity.getClass());
        boolean applied = valueReplacer.apply(new ListenerContext(entity, Scope.UPDATE));
        if (applied) {
            this.updateState(entity, currentState, propertyNames, valueReplacer.getPropertyDescriptorMap());
        }
        return applied;
    }

    public boolean onLoad(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        EntityValueReplacer valueReplacer = this.context.getEntityValueOverrider(entity.getClass());
        Map<String, PropertyDescriptor> descriptorMap = valueReplacer.getPropertyDescriptorMap();
        try {
            for (int i = 0; i < propertyNames.length; ++i) {
                String propertyName = propertyNames[i];
                PropertyDescriptor descriptor = descriptorMap.get(propertyName);
                if (descriptor == null || descriptor.getWriteMethod() == null) continue;
                descriptor.getWriteMethod().invoke(entity, state[i]);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.error.while.loading.entity"), (Throwable)e);
        }
        boolean applied = valueReplacer.apply(new ListenerContext(entity, Scope.READ));
        if (applied) {
            this.updateState(entity, state, propertyNames, descriptorMap);
        }
        return applied;
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        EntityValueReplacer valueReplacer = this.context.getEntityValueOverrider(entity.getClass());
        boolean applied = valueReplacer.apply(new ListenerContext(entity, Scope.INSERT));
        if (applied) {
            this.updateState(entity, state, propertyNames, valueReplacer.getPropertyDescriptorMap());
        }
        return applied;
    }

    private void updateState(Object entity, Object[] state, String[] propertyNames, Map<String, PropertyDescriptor> descriptorMap) {
        try {
            for (int i = 0; i < propertyNames.length; ++i) {
                Object value;
                PropertyDescriptor descriptor = descriptorMap.get(propertyNames[i]);
                if (descriptor == null || descriptor.getReadMethod() == null || !this.isNotCollectionType(descriptor)) continue;
                state[i] = value = descriptor.getReadMethod().invoke(entity, new Object[0]);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.state.parameters.update.error"), (Throwable)e);
        }
    }

    private boolean isNotCollectionType(PropertyDescriptor descriptor) {
        return !Collection.class.isAssignableFrom(descriptor.getPropertyType()) && !Map.class.isAssignableFrom(descriptor.getPropertyType());
    }
}

