/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.runtime.data.converters.BlobTypeConverter;
import com.wavemaker.runtime.data.converters.DateTimeConverter;
import com.wavemaker.runtime.data.converters.DateTypeConverter;
import com.wavemaker.runtime.data.converters.HibernateBackedJavaTypeConverter;
import com.wavemaker.runtime.data.converters.JavaTypeConverter;
import com.wavemaker.runtime.data.converters.ObjectTypeConverter;
import com.wavemaker.runtime.data.converters.StringTypeConverter;
import com.wavemaker.runtime.data.converters.TimeTypeConverter;
import com.wavemaker.runtime.data.converters.TimestampTypeConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.BigIntegerType;
import org.hibernate.type.BooleanType;
import org.hibernate.type.ByteType;
import org.hibernate.type.CharacterType;
import org.hibernate.type.DoubleType;
import org.hibernate.type.FloatType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LongType;
import org.hibernate.type.ShortType;
import org.hibernate.type.TrueFalseType;
import org.hibernate.type.YesNoType;

public enum JavaType {
    BYTE(Byte.TYPE.getName(), Byte.class.getName(), new HibernateBackedJavaTypeConverter(ByteType.INSTANCE.getJavaTypeDescriptor())),
    SHORT(Short.TYPE.getName(), Short.class.getName(), new HibernateBackedJavaTypeConverter(ShortType.INSTANCE.getJavaTypeDescriptor())),
    INTEGER(Integer.TYPE.getName(), Integer.class.getName(), new HibernateBackedJavaTypeConverter(IntegerType.INSTANCE.getJavaTypeDescriptor())),
    LONG(Long.TYPE.getName(), Long.class.getName(), new HibernateBackedJavaTypeConverter(LongType.INSTANCE.getJavaTypeDescriptor())),
    BIG_INTEGER(BigInteger.class.getName(), new HibernateBackedJavaTypeConverter(BigIntegerType.INSTANCE.getJavaTypeDescriptor())),
    FLOAT(Float.TYPE.getName(), Float.class.getName(), new HibernateBackedJavaTypeConverter(FloatType.INSTANCE.getJavaTypeDescriptor())),
    DOUBLE(Double.TYPE.getName(), Double.class.getName(), new HibernateBackedJavaTypeConverter(DoubleType.INSTANCE.getJavaTypeDescriptor())),
    BIG_DECIMAL(BigDecimal.class.getName(), new HibernateBackedJavaTypeConverter(BigDecimalType.INSTANCE.getJavaTypeDescriptor())),
    BOOLEAN(Boolean.TYPE.getName(), Boolean.class.getName(), new HibernateBackedJavaTypeConverter(BooleanType.INSTANCE.getJavaTypeDescriptor())),
    YES_OR_NO(Boolean.TYPE.getName(), Boolean.class.getName(), new HibernateBackedJavaTypeConverter(YesNoType.INSTANCE.getJavaTypeDescriptor())),
    TRUE_OR_FALSE(Boolean.TYPE.getName(), Boolean.class.getName(), new HibernateBackedJavaTypeConverter(TrueFalseType.INSTANCE.getJavaTypeDescriptor())),
    CHARACTER(Character.TYPE.getName(), Character.class.getName(), new HibernateBackedJavaTypeConverter(CharacterType.INSTANCE.getJavaTypeDescriptor())),
    STRING(String.class.getName(), new StringTypeConverter()),
    TEXT(String.class.getName(), new StringTypeConverter()),
    CLOB(String.class.getName(), new StringTypeConverter()),
    BLOB("byte[]", new BlobTypeConverter()){

        @Override
        public Class<?> getClassType() {
            return byte[].class;
        }
    }
    ,
    DATE(Date.class.getName(), new DateTypeConverter()),
    TIME(Time.class.getName(), new TimeTypeConverter()),
    DATETIME(LocalDateTime.class.getName(), new DateTimeConverter()),
    TIMESTAMP(Timestamp.class.getName(), new TimestampTypeConverter()),
    CURSOR(Object.class.getName(), new ObjectTypeConverter());

    private static Map<String, JavaType> javaTypeMap;
    private static List<JavaType> integerTypes;
    private static List<JavaType> decimalTypes;
    private static List<JavaType> numericTypes;
    private final String className;
    private final String primitiveClassName;
    private final JavaTypeConverter converter;

    private JavaType(String primitiveClassName, String wrapperClassName, JavaTypeConverter converter) {
        this.primitiveClassName = primitiveClassName;
        this.className = wrapperClassName;
        this.converter = converter;
    }

    private JavaType(String className, JavaTypeConverter converter) {
        this(className, className, converter);
    }

    public String getClassName() {
        return this.className;
    }

    public Class<?> getClassType() {
        try {
            return Class.forName(this.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new WMRuntimeException((Throwable)e);
        }
    }

    public String getPrimitiveClassName() {
        return this.primitiveClassName;
    }

    public static List<JavaType> integerTypes() {
        return integerTypes;
    }

    public static List<JavaType> decimalTypes() {
        return decimalTypes;
    }

    public static List<JavaType> numericTypes() {
        return numericTypes;
    }

    public boolean isNumericType() {
        return JavaType.numericTypes().contains((Object)this);
    }

    public boolean isDecimalType() {
        return JavaType.decimalTypes().contains((Object)this);
    }

    public boolean isIntegerType() {
        return JavaType.integerTypes().contains((Object)this);
    }

    public Object fromDbValue(Object fromValue) {
        return this.converter.fromDbValue(fromValue);
    }

    public Object fromString(String fromValue) {
        return this.converter.fromString(fromValue);
    }

    public Object toDbValue(Object fromValue) {
        return this.converter.toDbValue(fromValue, this.getClassType());
    }

    @JsonCreator
    public static JavaType fromValue(String value) {
        return javaTypeMap.get(value);
    }

    @JsonValue
    public String toValue() {
        return this.name().toLowerCase();
    }

    static {
        javaTypeMap = new HashMap<String, JavaType>();
        integerTypes = Arrays.asList(SHORT, INTEGER, LONG, BIG_INTEGER);
        decimalTypes = Arrays.asList(FLOAT, DOUBLE, BIG_DECIMAL);
        numericTypes = new ArrayList<JavaType>();
        for (JavaType javaType : JavaType.values()) {
            javaTypeMap.put(javaType.toValue(), javaType);
        }
        numericTypes.addAll(integerTypes);
        numericTypes.addAll(decimalTypes);
    }
}

