/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.model.queries;

import com.wavemaker.runtime.data.model.queries.QueryParameter;
import com.wavemaker.runtime.data.model.queries.QueryType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

public class RuntimeQuery {
    @NotEmpty
    private String queryString;
    private String countQueryString;
    private String offlineQueryString;
    private boolean nativeSql;
    private boolean fetchCount;
    @NotNull
    private QueryType type;
    private List<QueryParameter> parameters;

    public RuntimeQuery() {
        this.parameters = new ArrayList<QueryParameter>();
    }

    public RuntimeQuery(String queryString, boolean nativeSql, QueryType type, List<QueryParameter> parameters) {
        this.queryString = queryString;
        this.nativeSql = nativeSql;
        this.type = type;
        this.parameters = parameters;
    }

    public RuntimeQuery(RuntimeQuery other) {
        this.queryString = other.queryString;
        this.type = other.type;
        this.countQueryString = other.countQueryString;
        this.fetchCount = other.fetchCount;
        this.nativeSql = other.nativeSql;
        this.parameters = other.parameters;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getOfflineQueryString() {
        return this.offlineQueryString;
    }

    public void setOfflineQueryString(String offlineQueryString) {
        this.offlineQueryString = offlineQueryString;
    }

    public QueryType getType() {
        return this.type;
    }

    public void setType(QueryType type) {
        this.type = type;
    }

    public String getCountQueryString() {
        return this.countQueryString;
    }

    public void setCountQueryString(String countQueryString) {
        this.countQueryString = countQueryString;
    }

    public boolean isFetchCount() {
        return this.fetchCount;
    }

    public void setFetchCount(boolean fetchCount) {
        this.fetchCount = fetchCount;
    }

    public boolean isNativeSql() {
        return this.nativeSql;
    }

    public void setNativeSql(boolean nativeSql) {
        this.nativeSql = nativeSql;
    }

    public List<QueryParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<QueryParameter> parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RuntimeQuery)) {
            return false;
        }
        RuntimeQuery that = (RuntimeQuery)o;
        return this.isNativeSql() == that.isNativeSql() && Objects.equals(this.getQueryString(), that.getQueryString()) && Objects.equals(this.getParameters(), that.getParameters());
    }

    public int hashCode() {
        return Objects.hash(this.getQueryString(), this.isNativeSql(), this.getParameters());
    }

    public String toString() {
        return "RuntimeQuery{query='" + this.queryString + "', nativeSql=" + this.nativeSql + ", parameters=" + this.parameters + "}";
    }
}

