/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.model.returns;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.wavemaker.runtime.data.model.JavaType;
import com.wavemaker.runtime.data.model.returns.FieldType;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

public class ReturnProperty {
    @NotEmpty
    private String name;
    private String fieldName;
    private boolean optional;
    @NotNull
    private FieldType fieldType;

    public ReturnProperty() {
    }

    public ReturnProperty(String name, FieldType fieldType) {
        this.name = name;
        this.fieldType = fieldType;
    }

    public ReturnProperty(String name, String fieldName, FieldType fieldType) {
        this.name = name;
        this.fieldName = fieldName;
        this.fieldType = fieldType;
    }

    public ReturnProperty(ReturnProperty other) {
        this.name = other.name;
        this.fieldName = other.fieldName;
        this.optional = other.optional;
        this.fieldType = other.fieldType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(FieldType fieldType) {
        this.fieldType = fieldType;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    @JsonIgnore
    public boolean isBlobType() {
        return JavaType.BLOB.getClassName().equals(this.fieldType.getTypeRef());
    }

    public ReturnProperty clone() {
        return new ReturnProperty(this);
    }
}

