/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.periods;

import com.wavemaker.runtime.data.annotations.TableTemporal;
import com.wavemaker.runtime.data.filter.WMQueryInfo;
import com.wavemaker.runtime.data.filter.WMQueryParamInfo;
import com.wavemaker.runtime.data.periods.PeriodClause;
import java.util.Date;
import java.util.HashMap;

public class BetweenClause
implements PeriodClause {
    private final TableTemporal.TemporalType type;
    private final Date from;
    private final Date to;

    public BetweenClause(TableTemporal.TemporalType type, Date from, Date to) {
        this.type = type;
        this.from = from;
        this.to = to;
    }

    @Override
    public WMQueryInfo asWMQueryClause() {
        String var1Name = "wm_" + this.type.asHqlKeyword() + "_from_timestamp";
        String var2Name = "wm_" + this.type.asHqlKeyword() + "_and_timestamp";
        String hql = this.type.asHqlKeyword() + " between :" + var1Name + " and :" + var2Name;
        HashMap<String, WMQueryParamInfo> parameters = new HashMap<String, WMQueryParamInfo>(2);
        parameters.put(var1Name, new WMQueryParamInfo(this.from));
        parameters.put(var2Name, new WMQueryParamInfo(this.to));
        return new WMQueryInfo(hql, parameters);
    }
}

