/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.periods;

import com.wavemaker.commons.InvalidInputException;
import com.wavemaker.runtime.data.annotations.TableTemporal;
import com.wavemaker.runtime.data.filter.WMQueryInfo;
import com.wavemaker.runtime.data.model.JavaType;
import com.wavemaker.runtime.data.periods.AsOfClause;
import com.wavemaker.runtime.data.periods.BetweenClause;
import com.wavemaker.runtime.data.periods.FromToClause;
import com.wavemaker.runtime.data.periods.PeriodClause;
import java.sql.Timestamp;
import org.springframework.util.Assert;

public class PeriodClauseWrapper
implements PeriodClause {
    private static final String ERROR_MESSAGE = "period clause should be as_of <arg>, from_to <arg1> <arg2>, between <arg1> <arg2>";
    private PeriodClause periodClause;

    public PeriodClauseWrapper(TableTemporal.TemporalType type, String clause) {
        block5: {
            String[] tokens = clause.split("\\s");
            String periodType = tokens[0];
            try {
                if ("as_of".equalsIgnoreCase(periodType)) {
                    Assert.isTrue((tokens.length == 2 ? 1 : 0) != 0, (String)"As of clause MUST have one argument");
                    this.periodClause = new AsOfClause(type, (Timestamp)JavaType.TIMESTAMP.fromString(tokens[1]));
                    break block5;
                }
                if ("from_to".equalsIgnoreCase(periodType)) {
                    Assert.isTrue((tokens.length == 3 ? 1 : 0) != 0, (String)"FromTo clause MUST have two arguments");
                    Timestamp from = (Timestamp)JavaType.TIMESTAMP.fromString(tokens[1]);
                    Timestamp to = (Timestamp)JavaType.TIMESTAMP.fromString(tokens[2]);
                    this.periodClause = new FromToClause(type, from, to);
                    break block5;
                }
                if ("between".equalsIgnoreCase(periodType)) {
                    Assert.isTrue((tokens.length == 3 ? 1 : 0) != 0, (String)"Between clause MUST have two arguments");
                    Timestamp from = (Timestamp)JavaType.TIMESTAMP.fromString(tokens[1]);
                    Timestamp to = (Timestamp)JavaType.TIMESTAMP.fromString(tokens[2]);
                    this.periodClause = new BetweenClause(type, from, to);
                    break block5;
                }
                throw new InvalidInputException(ERROR_MESSAGE);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidInputException(e.getMessage() + ", Syntax:period clause should be as_of <arg>, from_to <arg1> <arg2>, between <arg1> <arg2>", (Throwable)e);
            }
        }
    }

    @Override
    public WMQueryInfo asWMQueryClause() {
        return this.periodClause.asWMQueryClause();
    }
}

