/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.replacers;

import com.wavemaker.runtime.commons.variable.Scope;
import com.wavemaker.runtime.data.replacers.EntityValueReplacer;
import com.wavemaker.runtime.data.replacers.FieldValueReplacer;
import com.wavemaker.runtime.data.replacers.ValueProvider;
import com.wavemaker.runtime.data.replacers.ValueProviderBuilder;
import com.wavemaker.runtime.data.replacers.ValueProviderFactory;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.util.LinkedMultiValueMap;

public class EntityValueReplacerBuilder {
    public EntityValueReplacer build(Class<?> type) {
        LinkedMultiValueMap overriderMultiValueMap = new LinkedMultiValueMap(Scope.values().length);
        for (Scope phase : Scope.values()) {
            overriderMultiValueMap.put((Object)phase, new ArrayList());
        }
        Map<Field, PropertyDescriptor> fieldDescriptorMap = this.buildDescriptorMap(type);
        for (Map.Entry<Field, PropertyDescriptor> entry : fieldDescriptorMap.entrySet()) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = entry.getKey().getAnnotations()) {
                if (!ValueProviderFactory.contains(annotation.annotationType())) continue;
                ValueProviderBuilder builder = ValueProviderFactory.getBuilder(annotation.annotationType());
                ValueProvider provider = builder.build(entry.getKey(), fieldDescriptorMap, annotation);
                FieldValueReplacer fieldValueReplacer = new FieldValueReplacer(entry.getValue(), provider);
                Set<Scope> scopes = provider.scopes();
                if (scopes.contains(Scope.INSERT)) {
                    overriderMultiValueMap.add((Object)Scope.INSERT, (Object)fieldValueReplacer);
                }
                if (scopes.contains(Scope.UPDATE)) {
                    overriderMultiValueMap.add((Object)Scope.UPDATE, (Object)fieldValueReplacer);
                }
                if (scopes.contains(Scope.DELETE)) {
                    overriderMultiValueMap.add((Object)Scope.DELETE, (Object)fieldValueReplacer);
                }
                if (!scopes.contains(Scope.READ)) continue;
                overriderMultiValueMap.add((Object)Scope.READ, (Object)fieldValueReplacer);
            }
        }
        return new EntityValueReplacer(this.convert(fieldDescriptorMap), (Map<Scope, List<FieldValueReplacer>>)overriderMultiValueMap);
    }

    private Map<String, PropertyDescriptor> convert(Map<Field, PropertyDescriptor> fieldPropertyDescriptorMap) {
        HashMap<String, PropertyDescriptor> propertyDescriptorMap = new HashMap<String, PropertyDescriptor>(fieldPropertyDescriptorMap.size());
        for (Map.Entry<Field, PropertyDescriptor> entry : fieldPropertyDescriptorMap.entrySet()) {
            propertyDescriptorMap.put(entry.getKey().getName(), entry.getValue());
        }
        return propertyDescriptorMap;
    }

    private Map<Field, PropertyDescriptor> buildDescriptorMap(Class<?> type) {
        HashMap<Field, PropertyDescriptor> propertyDescriptorMap = new HashMap<Field, PropertyDescriptor>();
        for (Field field : type.getDeclaredFields()) {
            PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor(type, (String)field.getName());
            propertyDescriptorMap.put(field, descriptor);
        }
        return propertyDescriptorMap;
    }
}

