/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.service;

import com.wavemaker.commons.util.StringTemplate;
import com.wavemaker.runtime.commons.WMAppContext;
import com.wavemaker.runtime.data.model.ReferenceType;
import com.wavemaker.runtime.data.model.returns.FieldType;
import com.wavemaker.runtime.data.model.returns.ReturnProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class AbstractDesignService {
    private static final StringTemplate TRANSACTION_MANAGER_BEAN_ST = new StringTemplate("${serviceId}TransactionManager");

    protected <T> T executeInTransaction(String serviceId, TransactionCallback<T> callback) {
        String transactionManagerBeanName = TRANSACTION_MANAGER_BEAN_ST.substitute(this.getStringTemplateMap(serviceId));
        PlatformTransactionManager transactionManager = (PlatformTransactionManager)WMAppContext.getInstance().getSpringBean(transactionManagerBeanName);
        TransactionTemplate txTemplate = new TransactionTemplate(transactionManager);
        txTemplate.setPropagationBehavior(3);
        return (T)txTemplate.execute(callback);
    }

    protected List<ReturnProperty> extractMetaFromResults(Collection<Object> results) {
        Object result;
        ArrayList<ReturnProperty> properties = new ArrayList<ReturnProperty>();
        if (!results.isEmpty() && (result = results.iterator().next()) instanceof Map) {
            Map resultMap = (Map)result;
            for (Map.Entry entry : resultMap.entrySet()) {
                FieldType fieldType;
                Object value = entry.getValue();
                if (value instanceof Collection) {
                    fieldType = new FieldType();
                    fieldType.setList(true);
                    fieldType.setType(ReferenceType.CUSTOM);
                    fieldType.setProperties(this.extractMetaFromResults((Collection)value));
                } else {
                    String type = value == null ? Object.class.getName() : value.getClass().getCanonicalName();
                    fieldType = new FieldType(ReferenceType.PRIMITIVE, type);
                }
                properties.add(new ReturnProperty((String)entry.getKey(), fieldType));
            }
        }
        return properties;
    }

    protected Map<String, String> getStringTemplateMap(String serviceId) {
        return Collections.singletonMap("serviceId", serviceId);
    }
}

