/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.service;

import com.wavemaker.runtime.data.dao.procedure.parameters.ResolvableParam;
import com.wavemaker.runtime.data.dao.procedure.parameters.TestParameter;
import com.wavemaker.runtime.data.dao.util.QueryHelper;
import com.wavemaker.runtime.data.model.ReferenceType;
import com.wavemaker.runtime.data.model.procedures.ProcedureParameter;
import com.wavemaker.runtime.data.model.procedures.RuntimeProcedure;
import com.wavemaker.runtime.data.model.queries.QueryType;
import com.wavemaker.runtime.data.model.queries.RuntimeQuery;
import com.wavemaker.runtime.data.model.returns.FieldType;
import com.wavemaker.runtime.data.model.returns.ReturnProperty;
import com.wavemaker.runtime.data.util.DataServiceUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DesignTimeServiceUtils {
    private DesignTimeServiceUtils() {
    }

    public static boolean isDMLOrUpdateQuery(RuntimeQuery query) {
        return query.getType() != QueryType.SELECT && DataServiceUtils.isDML(query.getQueryString());
    }

    public static List<ReturnProperty> getMetaForDML() {
        return Collections.singletonList(new ReturnProperty(null, new FieldType(ReferenceType.PRIMITIVE, Integer.class.getName())));
    }

    public static List<ResolvableParam> prepareParameters(RuntimeProcedure procedure) {
        ArrayList<ResolvableParam> testParameters = new ArrayList<ResolvableParam>(procedure.getParameters().size());
        List<ProcedureParameter> parameters = QueryHelper.prepareProcedureParameters(procedure);
        for (ProcedureParameter parameter : parameters) {
            testParameters.add(new TestParameter(parameter));
        }
        return testParameters;
    }
}

