/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.service;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.commons.util.StringTemplate;
import com.wavemaker.runtime.commons.WMAppContext;
import com.wavemaker.runtime.data.dao.query.WMQueryExecutor;
import com.wavemaker.runtime.data.model.DesignServiceResponse;
import com.wavemaker.runtime.data.model.queries.RuntimeQuery;
import com.wavemaker.runtime.data.model.returns.ReturnProperty;
import com.wavemaker.runtime.data.service.AbstractDesignService;
import com.wavemaker.runtime.data.service.DesignTimeServiceUtils;
import com.wavemaker.runtime.data.service.QueryDesignService;
import com.wavemaker.runtime.data.util.HQLQueryUtils;
import com.wavemaker.runtime.data.util.MultipartQueryUtils;
import java.util.List;
import java.util.Map;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.Query;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class QueryDesignServiceImpl
extends AbstractDesignService
implements QueryDesignService {
    private static final StringTemplate QUERY_EXECUTOR_BEAN_ST = new StringTemplate("${serviceId}WMQueryExecutor");
    private static final StringTemplate SESSION_FACTORY_BEAN_ST = new StringTemplate("${serviceId}SessionFactory");

    @Override
    public DesignServiceResponse testRunQuery(String serviceId, MultipartHttpServletRequest request, Pageable pageable) {
        RuntimeQuery query = MultipartQueryUtils.readContent(request, RuntimeQuery.class);
        MultipartQueryUtils.setMultiparts(query.getParameters(), (MultiValueMap<String, MultipartFile>)request.getMultiFileMap());
        return this.testRunQuery(serviceId, query, pageable);
    }

    @Override
    public DesignServiceResponse testRunQuery(String serviceId, RuntimeQuery query, Pageable pageable) {
        Object results = this._runQuery(serviceId, query, pageable);
        List<ReturnProperty> meta = DesignTimeServiceUtils.isDMLOrUpdateQuery(query) ? DesignTimeServiceUtils.getMetaForDML() : (query.isNativeSql() ? this.extractMetaFromResults(((Page)results).getContent()) : (List<ReturnProperty>)this.executeInTransaction(serviceId, status -> this.extractMetaForHql(serviceId, query)));
        return new DesignServiceResponse(results, meta);
    }

    @Override
    public Object executeQuery(String serviceId, RuntimeQuery query, Pageable pageable) {
        if (DesignTimeServiceUtils.isDMLOrUpdateQuery(query)) {
            throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.update.query.not.allowed"));
        }
        return this._runQuery(serviceId, query, pageable);
    }

    protected Object _runQuery(String serviceId, RuntimeQuery query, Pageable pageable) {
        Map<String, String> map = this.getStringTemplateMap(serviceId);
        String queryExecutorBeanName = QUERY_EXECUTOR_BEAN_ST.substitute(map);
        return this.executeInTransaction(serviceId, status -> {
            WMQueryExecutor queryExecutor = (WMQueryExecutor)WMAppContext.getInstance().getSpringBean(queryExecutorBeanName);
            Page<Object> response = DesignTimeServiceUtils.isDMLOrUpdateQuery(query) ? Integer.valueOf(queryExecutor.executeRuntimeQueryForUpdate(query)) : queryExecutor.executeRuntimeQuery(query, pageable);
            return response;
        });
    }

    protected List<ReturnProperty> extractMetaForHql(String serviceId, RuntimeQuery query) {
        String sessionFactoryBeanName = SESSION_FACTORY_BEAN_ST.substitute(this.getStringTemplateMap(serviceId));
        SessionFactoryImplementor factory = (SessionFactoryImplementor)WMAppContext.getInstance().getSpringBean(sessionFactoryBeanName);
        Query hqlQuery = factory.getCurrentSession().createQuery(query.getQueryString());
        return HQLQueryUtils.extractMetaForHql(hqlQuery);
    }
}

