/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.transform;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.runtime.data.annotations.ColumnAlias;
import com.wavemaker.runtime.data.exception.TypeMappingException;
import com.wavemaker.runtime.data.transform.Transformers;
import com.wavemaker.runtime.data.transform.WMResultTransformer;
import com.wavemaker.runtime.data.util.JavaTypeUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.hibernate.transform.AliasedTupleSubsetResultTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class AliasToMappedClassResultTransformer
extends AliasedTupleSubsetResultTransformer
implements WMResultTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AliasToMappedClassResultTransformer.class);
    private static Set<String> ignorableAliases = new HashSet<String>();
    private final Class resultClass;
    private Map<String, PropertyDescriptor> aliasVsDescriptorMap;
    private Map<String, String> fieldVsAliasMap;

    public AliasToMappedClassResultTransformer(Class resultClass) {
        Objects.requireNonNull(resultClass, "Result Class cannot be null");
        this.resultClass = resultClass;
        this.initialize();
    }

    public Object transformTuple(Object[] tuple, String[] aliases) {
        try {
            Object object = this.resultClass.newInstance();
            for (int i = 0; i < tuple.length; ++i) {
                this.applyValue(object, WMResultTransformer.getAlias(aliases, i), tuple[i]);
            }
            return object;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.cannot.instantiate.class"), (Throwable)e, new Object[]{this.resultClass});
        }
    }

    public boolean isTransformedValueATupleElement(String[] aliases, int tupleLength) {
        return false;
    }

    @Override
    public Object transformFromMap(Map<String, Object> resultMap) {
        try {
            Object object = this.resultClass.newInstance();
            for (Map.Entry<String, Object> entry : resultMap.entrySet()) {
                this.applyValue(object, entry.getKey(), entry.getValue());
            }
            return object;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.cannot.instantiate.class"), (Throwable)e, new Object[]{this.resultClass});
        }
    }

    @Override
    public String aliasToFieldName(String columnName) {
        String fieldName = columnName;
        if (this.aliasVsDescriptorMap.containsKey(columnName)) {
            fieldName = this.aliasVsDescriptorMap.get(columnName).getName();
        }
        return fieldName;
    }

    @Override
    public String aliasFromFieldName(String fieldName) {
        return this.fieldVsAliasMap.getOrDefault(fieldName, fieldName);
    }

    @Override
    public boolean containsField(String fieldName) {
        return this.fieldVsAliasMap.containsKey(fieldName);
    }

    private void applyValue(Object object, String alias, Object value) {
        if (this.aliasVsDescriptorMap.containsKey(alias)) {
            PropertyDescriptor descriptor = this.aliasVsDescriptorMap.get(alias);
            Object transformedValue = this.transformField(descriptor, value);
            try {
                descriptor.getWriteMethod().invoke(object, transformedValue);
            }
            catch (Throwable e) {
                throw new TypeMappingException(MessageResource.TYPE_MAPPING_FAILURE, e, alias, object.getClass().getName());
            }
        } else if (!ignorableAliases.contains(alias)) {
            LOGGER.warn("Column: {} not found in type:{}, ignoring", (Object)alias, (Object)this.resultClass.getName());
        }
    }

    private Object transformField(PropertyDescriptor descriptor, Object value) {
        Object transformedValue = value;
        if (value != null) {
            if (value instanceof List) {
                transformedValue = new ArrayList();
                Type innerType = ((ParameterizedType)descriptor.getReadMethod().getGenericReturnType()).getActualTypeArguments()[0];
                WMResultTransformer childTransformer = Transformers.aliasToMappedClass(TypeUtils.getRawType((Type)innerType, null));
                for (Map val : (List)value) {
                    ((List)transformedValue).add(childTransformer.transformFromMap(val));
                }
            } else {
                String className = descriptor.getPropertyType().getCanonicalName();
                transformedValue = JavaTypeUtils.convert(className, value);
            }
        }
        return transformedValue;
    }

    private void initialize() {
        Field[] fields = this.resultClass.getDeclaredFields();
        this.aliasVsDescriptorMap = new HashMap<String, PropertyDescriptor>();
        this.fieldVsAliasMap = new HashMap<String, String>();
        for (Field field : fields) {
            PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor((Class)this.resultClass, (String)field.getName());
            if (descriptor != null) {
                Optional<String> columnName = this.findResultSetColumnName(field);
                if (!columnName.isPresent() && descriptor.getReadMethod() != null) {
                    columnName = this.findResultSetColumnName(descriptor.getReadMethod());
                }
                if (!columnName.isPresent() && descriptor.getWriteMethod() != null) {
                    columnName = this.findResultSetColumnName(descriptor.getWriteMethod());
                }
                if (!columnName.isPresent()) {
                    columnName = Optional.of(field.getName());
                }
                this.aliasVsDescriptorMap.put(columnName.get(), descriptor);
                this.fieldVsAliasMap.put(descriptor.getName(), columnName.get());
                continue;
            }
            LOGGER.warn("Property descriptor not found for field:{}", (Object)field.getName());
        }
    }

    private Optional<String> findResultSetColumnName(AccessibleObject member) {
        Optional<String> rsColumn = Optional.empty();
        ColumnAlias annotation = member.getAnnotation(ColumnAlias.class);
        if (annotation != null) {
            rsColumn = Optional.of(annotation.value());
        }
        return rsColumn;
    }

    static {
        ignorableAliases.add("__hibernate_row_nr__");
    }
}

