/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.transform;

import com.wavemaker.runtime.data.transform.AliasToEntityLinkedHashMapTransformer;
import com.wavemaker.runtime.data.transform.AliasToMappedClassResultTransformer;
import com.wavemaker.runtime.data.transform.VoidTransformer;
import com.wavemaker.runtime.data.transform.WMResultTransformer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.ClassUtils;

public class Transformers {
    private final Map<Class<?>, WMResultTransformer> transformerMap = new HashMap();

    private Transformers() {
        this.transformerMap.put(Object.class, AliasToEntityLinkedHashMapTransformer.INSTANCE);
        this.transformerMap.put(Map.class, AliasToEntityLinkedHashMapTransformer.INSTANCE);
        this.transformerMap.put(Void.class, new VoidTransformer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WMResultTransformer get(Class<?> type) {
        if (!this.transformerMap.containsKey(type)) {
            Map<Class<?>, WMResultTransformer> map = this.transformerMap;
            synchronized (map) {
                if (!this.transformerMap.containsKey(type)) {
                    this.transformerMap.put(type, new AliasToMappedClassResultTransformer(type));
                }
            }
        }
        return this.transformerMap.get(type);
    }

    public static WMResultTransformer aliasToMappedClass(Class<?> type) {
        return TransformersHolder.INSTANCE.get(type);
    }

    public static Optional<WMResultTransformer> aliasToMappedClassOptional(Class<?> type) {
        if (ClassUtils.isPrimitiveOrWrapper(type) || Number.class.isAssignableFrom(type)) {
            return Optional.empty();
        }
        return Optional.ofNullable(Transformers.aliasToMappedClass(type));
    }

    private static class TransformersHolder {
        private static final Transformers INSTANCE = new Transformers();

        private TransformersHolder() {
        }
    }
}

