/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.util;

import com.wavemaker.runtime.data.util.PropertyDescription;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public abstract class AnnotationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationUtils.class);

    public static List<PropertyDescriptor> findProperties(Class<?> type, Class<? extends Annotation> annotationType) {
        return Arrays.stream(type.getDeclaredFields()).map(field -> ImmutablePair.of((Object)field, (Object)BeanUtils.getPropertyDescriptor((Class)type, (String)field.getName()))).filter(pair -> {
            Field field = (Field)pair.getLeft();
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)pair.getRight();
            boolean found = field.isAnnotationPresent(annotationType);
            if (propertyDescriptor != null) {
                if (propertyDescriptor.getReadMethod() != null) {
                    found = found || propertyDescriptor.getReadMethod().isAnnotationPresent(annotationType);
                } else {
                    LOGGER.warn("Read method not found for field: {} in class: {}", (Object)field.getName(), (Object)type.getName());
                }
                if (propertyDescriptor.getWriteMethod() != null) {
                    found = found || propertyDescriptor.getWriteMethod().isAnnotationPresent(annotationType);
                } else {
                    LOGGER.warn("Write method not found for field: {} in class: {}", (Object)field.getName(), (Object)type.getName());
                }
            } else {
                LOGGER.warn("Property Descriptor not found for field: {} in class: {}", (Object)field.getName(), (Object)type.getName());
            }
            return found;
        }).map(pair -> (PropertyDescriptor)pair.getRight()).collect(Collectors.toList());
    }

    public static List<PropertyDescription> findProperties(Class<?> type) {
        return Arrays.stream(type.getDeclaredFields()).map(field -> new PropertyDescription((Field)field, BeanUtils.getPropertyDescriptor((Class)type, (String)field.getName()))).collect(Collectors.toList());
    }
}

