/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.util;

import com.wavemaker.runtime.data.expression.AttributeType;
import com.wavemaker.runtime.data.expression.QueryFilter;
import com.wavemaker.runtime.data.expression.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang3.ArrayUtils;
import org.hibernate.Session;

public abstract class DaoUtils {
    public static <T> List<T> findAllRemainingChildren(Session session, Class<T> entity, ChildrenFilter<T> filter) {
        return DaoUtils.findAllChildren(session, entity, filter);
    }

    public static <T> List<T> findAllChildren(Session session, Class<T> entity, ChildrenFilter<T> filter) {
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(entity);
        Root root = query.from(entity);
        if (!filter.existingChildren.isEmpty()) {
            query.select((Selection)root).where(new Predicate[]{builder.equal((Expression)root.get(filter.parentPropertyName), filter.parent), builder.not((Expression)root.in(filter.existingChildren))});
        } else {
            query.select((Selection)root).where((Expression)builder.equal((Expression)root.get(filter.parentPropertyName), filter.parent));
        }
        return session.createQuery(query).list();
    }

    public static void validateQueryFilters(QueryFilter[] queryFilters) {
        if (ArrayUtils.isNotEmpty((Object[])queryFilters)) {
            for (QueryFilter queryFilter : queryFilters) {
                Object attributeValue = queryFilter.getAttributeValue();
                if (attributeValue == null || queryFilter.getFilterCondition() == Type.NULL) continue;
                AttributeType attributeType = queryFilter.getAttributeType();
                if (attributeValue instanceof Collection) {
                    Collection collection = (Collection)attributeValue;
                    Object[] objects = collection.toArray();
                    DaoUtils.updateObjectsArray(objects, attributeType);
                    queryFilter.setAttributeValue(Arrays.asList(objects));
                    continue;
                }
                if (attributeValue.getClass().isArray()) {
                    Object[] objects = (Object[])attributeValue;
                    DaoUtils.updateObjectsArray(objects, attributeType);
                    queryFilter.setAttributeValue(objects);
                    continue;
                }
                queryFilter.setAttributeValue(DaoUtils.getUpdatedAttributeValue(attributeValue, attributeType));
            }
        }
    }

    private static void updateObjectsArray(Object[] objects, AttributeType attributeType) {
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = DaoUtils.getUpdatedAttributeValue(objects[i], attributeType);
        }
    }

    private static Object getUpdatedAttributeValue(Object attributeValue, AttributeType attributeType) {
        return attributeType.toJavaType(attributeValue);
    }

    public static class ChildrenFilter<T> {
        private String parentPropertyName;
        private Object parent;
        private List<T> existingChildren;

        public ChildrenFilter(String parentPropertyName, Object parent, List<T> existingChildren) {
            this.parentPropertyName = parentPropertyName;
            this.parent = parent;
            this.existingChildren = existingChildren;
        }

        public ChildrenFilter(String parentPropertyName, Object parent) {
            this(parentPropertyName, parent, Collections.emptyList());
        }
    }
}

