/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.util;

import com.wavemaker.commons.util.SystemUtils;
import com.wavemaker.runtime.data.exception.DataServiceRuntimeException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.dao.InvalidDataAccessResourceUsageException;

public class DataServiceUtils {
    private static final String WM_MYSQL_CLOUD_TOKEN_PATTERN_STRING = "\\{WM_CLOUD_MYSQL_HOST\\}(:[\\d]+)?";
    private static final Pattern WM_MYSQL_CLOUD_TOKEN_PATTERN = Pattern.compile("\\{WM_CLOUD_MYSQL_HOST\\}(:[\\d]+)?");

    public static RuntimeException unwrap(Throwable th) {
        InvalidDataAccessResourceUsageException e;
        if (th instanceof DataServiceRuntimeException) {
            return (DataServiceRuntimeException)((Object)th);
        }
        if (InvalidDataAccessResourceUsageException.class.isAssignableFrom((th = SystemUtils.getRootException((Throwable)th)).getClass()) && (e = (InvalidDataAccessResourceUsageException)th).getRootCause() != null) {
            th = e.getRootCause();
        }
        if (th instanceof RuntimeException) {
            return (RuntimeException)th;
        }
        return new DataServiceRuntimeException(th);
    }

    public static boolean isDML(String query) {
        String q = query.trim().toLowerCase();
        return !q.startsWith("select");
    }

    public static String replaceMySqlCloudToken(String url, String hostPortString) {
        Matcher matcher = WM_MYSQL_CLOUD_TOKEN_PATTERN.matcher(url);
        return matcher.replaceFirst(hostPortString);
    }

    private DataServiceUtils() {
    }
}

