/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.util;

import com.wavemaker.runtime.data.model.ReferenceType;
import com.wavemaker.runtime.data.model.returns.FieldType;
import com.wavemaker.runtime.data.model.returns.ReturnProperty;
import com.wavemaker.runtime.data.transform.WMResultTransformer;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.query.Query;
import org.hibernate.type.AbstractStandardBasicType;
import org.hibernate.type.Type;

public class HQLQueryUtils {
    public static List<ReturnProperty> extractMetaForHql(Query query) {
        Type[] returnTypes = query.getReturnTypes();
        String[] returnAliases = query.getReturnAliases();
        ArrayList<ReturnProperty> properties = new ArrayList<ReturnProperty>(returnTypes.length);
        for (int i = 0; i < returnTypes.length; ++i) {
            Type type = returnTypes[i];
            ReturnProperty property = new ReturnProperty();
            property.setName(WMResultTransformer.getAlias(returnAliases, i));
            FieldType fieldType = new FieldType();
            String typeRef = type.getName();
            if (type.isCollectionType()) {
                fieldType.setList(true);
            }
            if (type.isAssociationType()) {
                fieldType.setType(ReferenceType.ENTITY);
            } else {
                fieldType.setType(ReferenceType.PRIMITIVE);
            }
            if (type instanceof AbstractStandardBasicType) {
                Class typeClass = ((AbstractStandardBasicType)type).getJavaTypeDescriptor().getJavaTypeClass();
                typeRef = typeClass.getCanonicalName();
            }
            fieldType.setTypeRef(typeRef);
            property.setFieldType(fieldType);
            if (i == 0 && (returnAliases == null || returnAliases.length == 1) && fieldType.getType() == ReferenceType.ENTITY) {
                property.setName(null);
            }
            properties.add(property);
        }
        return properties;
    }
}

