/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.util;

import com.wavemaker.commons.CommonConstants;
import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.runtime.data.model.JavaType;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.dialect.OracleTypesHelper;

public class JDBCUtils {
    private static final Map<JavaType, Integer> javaTypeVsSqlTypeCodes = new HashMap<JavaType, Integer>();
    private static Map<Integer, JavaType> sqlTypeCodeVsJavaType = new HashMap<Integer, JavaType>();

    private JDBCUtils() {
    }

    public static int getSqlTypeCode(JavaType javaType) {
        Integer typeCode = javaTypeVsSqlTypeCodes.get((Object)javaType);
        if (typeCode == null) {
            if (javaType == JavaType.CURSOR) {
                typeCode = OracleTypesHelper.INSTANCE.getOracleCursorTypeSqlType();
            } else {
                throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.sql.type.code.not.found"), new Object[]{javaType});
            }
        }
        return typeCode;
    }

    public static JavaType getJavaType(Integer typeCode) {
        return sqlTypeCodeVsJavaType.get(typeCode);
    }

    static {
        javaTypeVsSqlTypeCodes.put(JavaType.BYTE, -6);
        javaTypeVsSqlTypeCodes.put(JavaType.SHORT, 5);
        javaTypeVsSqlTypeCodes.put(JavaType.INTEGER, 4);
        javaTypeVsSqlTypeCodes.put(JavaType.LONG, -5);
        javaTypeVsSqlTypeCodes.put(JavaType.BIG_INTEGER, -5);
        javaTypeVsSqlTypeCodes.put(JavaType.FLOAT, 6);
        javaTypeVsSqlTypeCodes.put(JavaType.DOUBLE, 8);
        javaTypeVsSqlTypeCodes.put(JavaType.BIG_DECIMAL, 3);
        javaTypeVsSqlTypeCodes.put(JavaType.BOOLEAN, 16);
        javaTypeVsSqlTypeCodes.put(JavaType.YES_OR_NO, 1);
        javaTypeVsSqlTypeCodes.put(JavaType.TRUE_OR_FALSE, 1);
        javaTypeVsSqlTypeCodes.put(JavaType.CHARACTER, 1);
        javaTypeVsSqlTypeCodes.put(JavaType.STRING, 12);
        javaTypeVsSqlTypeCodes.put(JavaType.TEXT, -1);
        javaTypeVsSqlTypeCodes.put(JavaType.CLOB, 2005);
        javaTypeVsSqlTypeCodes.put(JavaType.BLOB, 2004);
        javaTypeVsSqlTypeCodes.put(JavaType.DATE, 91);
        javaTypeVsSqlTypeCodes.put(JavaType.TIME, 92);
        javaTypeVsSqlTypeCodes.put(JavaType.DATETIME, 93);
        javaTypeVsSqlTypeCodes.put(JavaType.TIMESTAMP, 93);
        sqlTypeCodeVsJavaType.put(-7, JavaType.BOOLEAN);
        sqlTypeCodeVsJavaType.put(16, JavaType.BOOLEAN);
        sqlTypeCodeVsJavaType.put(-6, JavaType.SHORT);
        sqlTypeCodeVsJavaType.put(5, JavaType.SHORT);
        sqlTypeCodeVsJavaType.put(4, JavaType.INTEGER);
        sqlTypeCodeVsJavaType.put(-5, JavaType.BIG_INTEGER);
        sqlTypeCodeVsJavaType.put(6, JavaType.FLOAT);
        sqlTypeCodeVsJavaType.put(7, JavaType.BIG_DECIMAL);
        sqlTypeCodeVsJavaType.put(8, JavaType.DOUBLE);
        sqlTypeCodeVsJavaType.put(2, JavaType.BIG_DECIMAL);
        sqlTypeCodeVsJavaType.put(3, JavaType.BIG_DECIMAL);
        sqlTypeCodeVsJavaType.put(-1, JavaType.TEXT);
        sqlTypeCodeVsJavaType.put(-16, JavaType.TEXT);
        sqlTypeCodeVsJavaType.put(12, JavaType.STRING);
        sqlTypeCodeVsJavaType.put(1, JavaType.CHARACTER);
        sqlTypeCodeVsJavaType.put(91, JavaType.DATE);
        sqlTypeCodeVsJavaType.put(92, JavaType.TIME);
        sqlTypeCodeVsJavaType.put(93, JavaType.TIMESTAMP);
        sqlTypeCodeVsJavaType.put(CommonConstants.DATE_TIME_WM_TYPE_CODE, JavaType.DATETIME);
        sqlTypeCodeVsJavaType.put(-2, JavaType.BLOB);
        sqlTypeCodeVsJavaType.put(-3, JavaType.BLOB);
        sqlTypeCodeVsJavaType.put(-4, JavaType.BLOB);
        sqlTypeCodeVsJavaType.put(2004, JavaType.BLOB);
        sqlTypeCodeVsJavaType.put(2005, JavaType.CLOB);
        sqlTypeCodeVsJavaType.put(-15, JavaType.STRING);
        sqlTypeCodeVsJavaType.put(-9, JavaType.STRING);
        sqlTypeCodeVsJavaType.put(2011, JavaType.CLOB);
    }
}

