/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.util;

import com.wavemaker.runtime.data.model.JavaType;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.hibernate.HibernateException;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class JavaTypeUtils {
    private static MultiValueMap<String, JavaType> classNameVsJavaTypeMap = new LinkedMultiValueMap();
    private static final Set<String> BOOLEAN_TRUE_CASES = new HashSet<String>();

    public static Object convert(String toClass, Object value) {
        Object convertedValue = value;
        if (classNameVsJavaTypeMap.containsKey((Object)toClass)) {
            for (JavaType javaType : (List)classNameVsJavaTypeMap.get((Object)toClass)) {
                try {
                    convertedValue = javaType.fromDbValue(value);
                    break;
                }
                catch (HibernateException hibernateException) {
                }
            }
        }
        return convertedValue;
    }

    public static Optional<JavaType> fromClassName(String className) {
        return Optional.ofNullable((JavaType)((Object)classNameVsJavaTypeMap.getFirst((Object)className)));
    }

    public static boolean isKnownType(Class<?> type) {
        String typeName = (type = ClassUtils.primitiveToWrapper(type)).getCanonicalName();
        return classNameVsJavaTypeMap.containsKey((Object)typeName) || Date.class.isAssignableFrom(type);
    }

    public static boolean isNotCollectionType(Class<?> typeClass) {
        return !Collection.class.isAssignableFrom(typeClass);
    }

    public static boolean isTrue(String booleanInString) {
        return BOOLEAN_TRUE_CASES.contains(booleanInString.toLowerCase());
    }

    static {
        for (JavaType javaType : JavaType.values()) {
            classNameVsJavaTypeMap.add((Object)javaType.getClassName(), (Object)javaType);
            classNameVsJavaTypeMap.add((Object)javaType.getPrimitiveClassName(), (Object)javaType);
        }
        classNameVsJavaTypeMap.add((Object)Date.class.getCanonicalName(), (Object)JavaType.DATE);
        BOOLEAN_TRUE_CASES.add("1");
        BOOLEAN_TRUE_CASES.add("true");
        BOOLEAN_TRUE_CASES.add("t");
        BOOLEAN_TRUE_CASES.add("y");
    }
}

