/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.util;

import com.wavemaker.commons.InvalidInputException;
import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.commons.json.JSONUtils;
import com.wavemaker.runtime.data.model.queries.QueryParameter;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class MultipartQueryUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultipartQueryUtils.class);

    private MultipartQueryUtils() {
    }

    public static <T> T readContent(MultipartHttpServletRequest request, Class<T> type) {
        Object instance;
        MultipartFile multipartFile = request.getFile("wm_data_json");
        try {
            if (multipartFile == null) {
                String wmJson = request.getParameter("wm_data_json");
                if (StringUtils.isBlank((CharSequence)wmJson)) {
                    LOGGER.error("Request does not have wm_data_json multipart data");
                    throw new InvalidInputException(MessageResource.create((String)"com.wavemaker.runtime.invalid.wm_data_json"), new Object[0]);
                }
                instance = JSONUtils.toObject((String)wmJson, type);
            } else {
                instance = JSONUtils.toObject((InputStream)multipartFile.getInputStream(), type);
            }
        }
        catch (IOException e) {
            throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.wm.data.body.read.error"), (Throwable)e);
        }
        return (T)instance;
    }

    public static <T extends QueryParameter> void setMultiparts(List<T> parameters, MultiValueMap<String, MultipartFile> parts) {
        if (!parts.isEmpty()) {
            for (String partName : parts.keySet()) {
                if ("wm_data_json".equals(partName)) continue;
                T parameter = MultipartQueryUtils.findParameter(parameters, partName);
                try {
                    ((QueryParameter)parameter).setTestValue(((MultipartFile)parts.getFirst((Object)partName)).getBytes());
                }
                catch (IOException e) {
                    throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.multipart.request.read.error"), (Throwable)e, new Object[]{partName});
                }
            }
        }
    }

    private static <T extends QueryParameter> T findParameter(List<T> parameters, String name) {
        for (QueryParameter parameter : parameters) {
            if (!Objects.equals(parameter.getName(), name)) continue;
            return (T)parameter;
        }
        throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.parameter.found"), new Object[]{name});
    }
}

