/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.util;

import com.wavemaker.runtime.data.model.CustomProcedureParam;
import com.wavemaker.runtime.data.model.procedures.ProcedureParameter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProceduresUtils {
    private static final String PARAM = "{param}";
    private static final String PROCEDURE_PARAM_PATTERN = "(\\:{param})([\\s*,]|[\\s*|,]|[\\s*\\)?]|[\\s*|\\)?]|$)";
    private static final String PROCEDURE_PARAM_REPLACE_STRING = "?";

    public static boolean hasOutParam(List<CustomProcedureParam> customProcedureParams) {
        for (CustomProcedureParam customProcedureParam : customProcedureParams) {
            if (!customProcedureParam.getProcedureParamType().isOutParam()) continue;
            return true;
        }
        return false;
    }

    public static String jdbcComplianceProcedure(String procedureStr, List<ProcedureParameter> params) {
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < params.size(); ++i) {
            ProcedureParameter param = params.get(i);
            names.add(param.getName());
        }
        return ProceduresUtils.jdbcComplianceProcedure(procedureStr, names);
    }

    public static String jdbcComplianceProcedure(String procedureStr, Set<String> namedParams) {
        String targetProcedureString = procedureStr;
        for (String namedParam : namedParams) {
            String procedurePattern = PROCEDURE_PARAM_PATTERN.replace(PARAM, namedParam);
            targetProcedureString = ProceduresUtils.replaceProcedureParam(targetProcedureString, procedurePattern);
        }
        return targetProcedureString;
    }

    private static String replaceProcedureParam(String procedureString, String procedurePattern) {
        Pattern pattern = Pattern.compile(procedurePattern);
        Matcher matcher = pattern.matcher(procedureString);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String value = PROCEDURE_PARAM_REPLACE_STRING + matcher.group(2);
            matcher.appendReplacement(sb, value);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

