/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.util;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Optional;

public class PropertyDescription {
    private final Field field;
    private final PropertyDescriptor descriptor;

    public PropertyDescription(Field field, PropertyDescriptor descriptor) {
        this.field = field;
        this.descriptor = descriptor;
    }

    public Field getField() {
        return this.field;
    }

    public PropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    public boolean isAnnotationNotPresent(Class<? extends Annotation> annotation) {
        return !this.isAnnotationPresent(annotation);
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        return this.findAnnotation(annotation).isPresent();
    }

    public <T extends Annotation> Optional<T> findAnnotation(Class<T> annotation) {
        Optional result = Optional.empty();
        if (this.field.isAnnotationPresent(annotation)) {
            result = Optional.of(this.field.getAnnotation(annotation));
        } else if (this.descriptor.getReadMethod().isAnnotationPresent(annotation)) {
            result = Optional.of(this.descriptor.getReadMethod().getAnnotation(annotation));
        } else if (this.descriptor.getWriteMethod().isAnnotationPresent(annotation)) {
            result = Optional.of(this.descriptor.getWriteMethod().getAnnotation(annotation));
        }
        return result;
    }
}

