/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.util;

import com.wavemaker.runtime.commons.WMAppContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public interface TransactionUtils {
    public static <T> T executeInReadOnlyTransaction(String txManagerId, TransactionCallback<T> callback) {
        return TransactionUtils.executeInTransaction(txManagerId, true, callback);
    }

    public static <T> T executeInTransaction(String txManagerId, boolean readOnly, TransactionCallback<T> callback) {
        PlatformTransactionManager transactionManager = (PlatformTransactionManager)WMAppContext.getInstance().getSpringBean(txManagerId);
        TransactionTemplate txTemplate = new TransactionTemplate(transactionManager);
        txTemplate.setPropagationBehavior(3);
        txTemplate.setReadOnly(readOnly);
        return (T)txTemplate.execute(callback);
    }
}

