/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.util;

import com.wavemaker.commons.InvalidInputException;
import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.commons.util.WMIOUtils;
import com.wavemaker.runtime.commons.WMAppContext;
import com.wavemaker.runtime.commons.WMAppObjectMapper;
import com.wavemaker.runtime.commons.file.model.DownloadResponse;
import com.wavemaker.runtime.commons.util.WMRandomUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class WMMultipartUtils {
    public static final String BLOB = "Blob";
    private static final Logger LOGGER = LoggerFactory.getLogger(WMMultipartUtils.class);
    private static final int FILE_NAME_LENGTH = 12;
    private static final String BYTE_ARRAY = "byte[]";

    public static <T> T toObject(MultipartHttpServletRequest multipartHttpServletRequest, Class<T> instance) {
        return WMMultipartUtils.toObject(multipartHttpServletRequest, instance, null);
    }

    public static <T> T toObject(MultipartHttpServletRequest multipartHttpServletRequest, Class<T> instance, String serviceId) {
        T t = null;
        try {
            MultipartFile multipartFile = multipartHttpServletRequest.getFile("wm_data_json");
            if (multipartFile == null) {
                String wmJson = multipartHttpServletRequest.getParameter("wm_data_json");
                if (StringUtils.isBlank((CharSequence)wmJson)) {
                    LOGGER.error("Request does not have wm_data_json multipart data");
                    throw new InvalidInputException(MessageResource.create((String)"com.wavemaker.runtime.request.emptyJson"), new Object[0]);
                }
                t = WMMultipartUtils.toObject(wmJson, instance);
            } else {
                t = WMMultipartUtils.toObject(multipartFile, instance);
            }
            WMMultipartUtils.setMultipartsToObject(multipartHttpServletRequest.getFileMap(), t, serviceId);
        }
        catch (IOException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error("Exception while creating a new Instance with information: {}", t);
            throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.multipart.request.exception"), (Throwable)e);
        }
        return t;
    }

    public static <T> T toObject(MultipartFile multipartFile, Class<T> instance) throws IOException {
        WMAppObjectMapper objectMapper = WMAppObjectMapper.getInstance();
        return (T)objectMapper.readValue(multipartFile.getInputStream(), instance);
    }

    public static <T> T toObject(String json, Class<T> instance) throws IOException {
        WMAppObjectMapper objectMapper = WMAppObjectMapper.getInstance();
        return (T)objectMapper.readValue(json, instance);
    }

    public static <T> T updateLobsContent(T oldInstance, T newInstance) {
        Field[] fields;
        for (Field field : fields = newInstance.getClass().getDeclaredFields()) {
            String type = field.getType().getSimpleName();
            if (!BYTE_ARRAY.equals(type) && !BLOB.equals(type)) continue;
            String getMethodName = "get" + StringUtils.capitalize((String)field.getName());
            try {
                Method getMethod = newInstance.getClass().getMethod(getMethodName, new Class[0]);
                Object object = getMethod.invoke(newInstance, new Object[0]);
                if (object != null && (!(object instanceof byte[]) || ((byte[])object).length != 0)) continue;
                String setMethodName = "set" + StringUtils.capitalize((String)field.getName());
                Method setMethod = newInstance.getClass().getMethod(setMethodName, field.getType());
                Object oldObject = getMethod.invoke(oldInstance, new Object[0]);
                setMethod.invoke(newInstance, oldObject);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error("Failed to update blob content", (Throwable)e);
                throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.blobContent.updated.failed"), (Throwable)e);
            }
        }
        return newInstance;
    }

    private static <T> T setMultipartsToObject(Map<String, MultipartFile> multiparts, T instance, String serviceId) throws IOException, NoSuchFieldException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> aClass = instance.getClass();
        for (Map.Entry<String, MultipartFile> part : multiparts.entrySet()) {
            if (part.getKey().equals("wm_data_json")) continue;
            Field field = aClass.getDeclaredField(part.getKey());
            ReflectionUtils.makeAccessible((Field)field);
            String methodName = "set" + StringUtils.capitalize((String)field.getName());
            Method method = aClass.getMethod(methodName, field.getType());
            WMMultipartUtils.invokeMethod(instance, part.getValue().getInputStream(), method, field, serviceId);
        }
        return instance;
    }

    private static <T> T invokeMethod(T instance, InputStream inputStream, Method method, Field field, String serviceId) throws IOException, IllegalAccessException, InvocationTargetException {
        byte[] byteArray = IOUtils.toByteArray((InputStream)inputStream);
        if (field.getType().isInstance("")) {
            String content = WMIOUtils.toString((InputStream)inputStream);
            method.invoke(instance, content);
        } else if (Objects.equals(BYTE_ARRAY, field.getType().getSimpleName())) {
            method.invoke(instance, new Object[]{byteArray});
        } else if (Objects.equals(BLOB, field.getType().getSimpleName())) {
            SessionFactory sessionFactory = (SessionFactory)WMAppContext.getInstance().getSpringBean(serviceId + "SessionFactory");
            try (Session session = sessionFactory.openSession();){
                Blob blob = Hibernate.getLobCreator((Session)session).createBlob((InputStream)new ByteArrayInputStream(byteArray), (long)byteArray.length);
                method.invoke(instance, blob);
            }
        } else {
            LOGGER.error("Casting multipart {} to {} is not supported", (Object)field.getName(), (Object)field.getType().getSimpleName());
            throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.multipart.casting.exception"), new Object[]{field.getName(), field.getType().getSimpleName()});
        }
        return instance;
    }

    public static byte[] toByteArray(MultipartFile file) {
        try {
            return file == null ? null : file.getBytes();
        }
        catch (IOException e) {
            throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.file.reading.error"), (Throwable)e);
        }
    }

    public static String guessContentType(byte[] data) {
        return new Tika().detect(data);
    }

    public static <T> void buildHttpResponseForBlob(T instance, String fieldName, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            byte[] bytes = WMMultipartUtils.getBlobBytes(instance, fieldName);
            httpServletResponse.setContentType(WMMultipartUtils.getMatchingContentType(bytes, httpServletRequest));
            httpServletResponse.setHeader("Content-Disposition", "filename=" + fieldName + new SecureRandom().nextInt(99) + ";size=" + bytes.length);
            int contentLength = IOUtils.copy((InputStream)new ByteArrayInputStream(bytes), (OutputStream)httpServletResponse.getOutputStream());
            httpServletResponse.setContentLength(contentLength);
        }
        catch (IOException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.response.construction.failed"), (Throwable)e, new Object[]{fieldName});
        }
    }

    public static <T> DownloadResponse buildDownloadResponseForBlob(T instance, String fieldName, HttpServletRequest httpServletRequest, boolean download) {
        DownloadResponse downloadResponse = new DownloadResponse();
        try {
            String fileExtension;
            byte[] bytes = WMMultipartUtils.getBlobBytes(instance, fieldName);
            String contentType = null;
            Object filename = httpServletRequest.getParameter("filename");
            if (StringUtils.isBlank((CharSequence)filename)) {
                filename = fieldName + System.currentTimeMillis();
            } else {
                contentType = new Tika().detect((String)filename);
            }
            if (contentType == null) {
                contentType = WMMultipartUtils.getMatchingContentType(bytes, httpServletRequest);
            }
            if (StringUtils.isNotBlank((CharSequence)(fileExtension = WMMultipartUtils.getFileExtensionFromContentType(contentType))) && !((String)filename).endsWith(fileExtension)) {
                filename = (String)filename + fileExtension;
            }
            downloadResponse.setContents((InputStream)new ByteArrayInputStream(bytes));
            downloadResponse.setContentType(contentType);
            downloadResponse.setFileName((String)filename);
            downloadResponse.setInline(!download);
        }
        catch (IOException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.response.construction.failed"), (Throwable)e, new Object[]{fieldName});
        }
        return downloadResponse;
    }

    private static String getFileExtensionFromContentType(String contentType) {
        try {
            MimeType mimeType = TikaConfig.getDefaultConfig().getMimeRepository().forName(contentType);
            return mimeType.getExtension();
        }
        catch (Exception e) {
            LOGGER.warn("Could not get file extension for file type {}", (Object)contentType);
            return "";
        }
    }

    private static MimeType getMimeTypeFromInputStream(InputStream is) {
        String contentType = null;
        try {
            contentType = new Tika().detect(is);
            return TikaConfig.getDefaultConfig().getMimeRepository().forName(contentType);
        }
        catch (IOException | MimeTypeException e) {
            LOGGER.warn("Could not get file extension for file type {}", (Object)contentType);
            return null;
        }
    }

    public static DownloadResponse buildDownloadResponse(HttpServletRequest request, InputStream is, boolean download) {
        DownloadResponse downloadResponse = new DownloadResponse();
        downloadResponse.setContents(is);
        downloadResponse.setInline(!download);
        String contentType = null;
        String filename = request.getParameter("filename");
        String extension = "";
        MimeType mimeType = WMMultipartUtils.getMimeTypeFromInputStream(is);
        if (mimeType != null) {
            contentType = mimeType.getName();
            extension = mimeType.getExtension();
        } else if (StringUtils.isNotBlank((CharSequence)filename)) {
            contentType = URLConnection.guessContentTypeFromName(filename);
        }
        if (StringUtils.isBlank((CharSequence)filename)) {
            filename = WMRandomUtils.getRandomString((int)12);
        }
        if (StringUtils.isBlank((CharSequence)contentType)) {
            contentType = "application/octet-stream";
        }
        downloadResponse.setContentType(contentType);
        if (filename.endsWith(extension)) {
            downloadResponse.setFileName(filename);
        } else {
            downloadResponse.setFileName(filename + extension);
        }
        return downloadResponse;
    }

    private static <T> byte[] getBlobBytes(T instance, String fieldName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, IOException {
        String methodName = "get" + StringUtils.capitalize((String)fieldName);
        Method method = instance.getClass().getMethod(methodName, new Class[0]);
        byte[] bytes = null;
        if (Objects.equals(BLOB, method.getReturnType().getSimpleName())) {
            Blob blob = (Blob)method.invoke(instance, new Object[0]);
            try {
                bytes = blob != null ? IOUtils.toByteArray((InputStream)blob.getBinaryStream()) : null;
            }
            catch (SQLException e) {
                throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.blobContent.cast.failed"), (Throwable)e);
            }
        } else if (Objects.equals(BYTE_ARRAY, method.getReturnType().getSimpleName())) {
            bytes = (byte[])method.invoke(instance, new Object[0]);
        }
        if (bytes == null) {
            throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.no.data.in.column"), new Object[]{fieldName});
        }
        return bytes;
    }

    private static String getMatchingContentType(byte[] bytes, HttpServletRequest httpServletRequest) {
        String contentType = WMMultipartUtils.guessContentType(bytes);
        if (contentType == null) {
            contentType = httpServletRequest.getContentType();
        }
        return contentType;
    }
}

