/*******************************************************************************
 * Copyright (C) 2022-2023 WaveMaker, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
package com.wavemaker.runtime.prefab.util;

import java.io.File;

/**
 * Holds constants used throughout the library.
 *
 * @author Dilip Kumar
 */
public class PrefabConstants {
    public static final File[] ZERO_FILES = new File[0];

    public static final String REQUEST_PREFAB_CONTEXT = "wm.request.prefabContext";

    public static final String PREFABS_PROP_FILE = "prefabs.properties";
    public static final String PREFAB_DEFAULT_DIRECTORY = "WEB-INF/prefabs";
    public static final String PREFAB_DEFAULT_LIB_DIR = "lib";
    public static final String PREFAB_DEFAULT_CONF_DIR = "config";
    public static final String PREFAB_DEFAULT_BUILD_DIR = "build";
}
