/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.prefab.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:prefabs.properties"})
public class PrefabsConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrefabsConfig.class);
    private static final String PREFAB_HOME_DIR_PROP = "prefabs.home.dir";
    private static final String PREFAB_LIB_DIR_PROP = "prefabs.lib.dir";
    private static final String PREFAB_CONFIG_DIR_PROP = "prefabs.config.dir";
    private static final String PREFAB_BUILD_DIR_PROP = "prefabs.build.dir";
    private String prefabsHomeDir;
    private String prefabLibDir;
    private String prefabConfigDir;
    private String prefabBuildDir;
    @Value(value="${app.prefabs.lazyInit:false}")
    private boolean lazyInitPrefabs;

    @Autowired
    public void setPrefabsHomeDir(@Value(value="${prefabs.home.dir}") String prefabsHomeDir) {
        this.prefabsHomeDir = this.defaultOnEmpty(prefabsHomeDir, "WEB-INF/prefabs", PREFAB_HOME_DIR_PROP);
    }

    @Autowired
    public void setPrefabLibDir(@Value(value="${prefabs.lib.dir}") String prefabLibDir) {
        this.prefabLibDir = this.defaultOnEmpty(prefabLibDir, "lib", PREFAB_LIB_DIR_PROP);
    }

    @Autowired
    public void setPrefabConfigDir(@Value(value="${prefabs.config.dir}") String prefabConfigDir) {
        this.prefabConfigDir = this.defaultOnEmpty(prefabConfigDir, "config", PREFAB_CONFIG_DIR_PROP);
    }

    @Autowired
    public void setPrefabBuildDir(@Value(value="${prefabs.build.dir}") String prefabBuildDir) {
        this.prefabBuildDir = this.defaultOnEmpty(prefabBuildDir, "build", PREFAB_BUILD_DIR_PROP);
    }

    public String getPrefabsHomeDir() {
        return this.prefabsHomeDir;
    }

    public String getPrefabLibDir() {
        return this.prefabLibDir;
    }

    public String getPrefabConfigDir() {
        return this.prefabConfigDir;
    }

    public String getPrefabBuildDir() {
        return this.prefabBuildDir;
    }

    public boolean isLazyInitPrefabs() {
        return this.lazyInitPrefabs;
    }

    private String defaultOnEmpty(String value, String defaultValue, String propKey) {
        if (value != null && !value.isEmpty()) {
            return value;
        }
        LOGGER.info("Property:'{}', Not found in properties file. Using default value:{}", (Object)propKey, (Object)defaultValue);
        return defaultValue;
    }
}

