/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.prefab.context;

import com.wavemaker.runtime.prefab.core.Prefab;
import javax.servlet.ServletContext;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.web.context.support.StandardServletEnvironment;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class PrefabWebApplicationContext
extends XmlWebApplicationContext {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrefabWebApplicationContext(Prefab prefab, ApplicationContext parent, ServletContext servletContext) {
        this.setId(prefab.getName());
        this.setParent(parent);
        this.setEnvironment((ConfigurableEnvironment)new StandardServletEnvironment());
        ClassLoader prefabClassLoader = prefab.getClassLoader();
        this.setClassLoader(prefabClassLoader);
        this.setServletContext(servletContext);
        this.setDisplayName("Prefab Context [" + prefab.getName() + "]");
        this.setConfigLocations(new String[]{"classpath:prefab-springapp.xml"});
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(prefabClassLoader);
            this.refresh();
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }
}

