/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.prefab.impl;

import com.wavemaker.commons.classloader.WMUrlClassLoader;
import com.wavemaker.runtime.prefab.core.Prefab;
import com.wavemaker.runtime.prefab.core.PrefabFactory;
import com.wavemaker.runtime.prefab.util.PrefabUtils;
import com.wavemaker.runtime.prefab.util.Utils;
import java.io.File;
import java.net.URL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrefabFactoryImpl
implements PrefabFactory {
    @Autowired
    private PrefabUtils prefabUtils;

    private URL[] getPrefabFiles(File prefabDir) {
        return Utils.convertToURLS(this.prefabUtils.getPrefabBuildDirectory(prefabDir), this.prefabUtils.readJarFilesForPrefab(prefabDir));
    }

    @Override
    public Prefab newPrefab(File prefabDir) throws Exception {
        String prefabName = prefabDir.getName();
        WMUrlClassLoader classLoader = new WMUrlClassLoader(this.getPrefabFiles(prefabDir), prefabName);
        return new Prefab(prefabName, (ClassLoader)classLoader);
    }
}

