/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.prefab.impl;

import com.wavemaker.commons.classloader.WMUrlClassLoader;
import com.wavemaker.commons.util.WMIOUtils;
import com.wavemaker.runtime.prefab.context.PrefabWebApplicationContext;
import com.wavemaker.runtime.prefab.core.Prefab;
import com.wavemaker.runtime.prefab.core.PrefabInstaller;
import com.wavemaker.runtime.prefab.core.PrefabManager;
import com.wavemaker.runtime.prefab.core.PrefabRegistry;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.web.context.ServletContextAware;

@Service
public class PrefabInstallerImpl
implements PrefabInstaller,
ApplicationContextAware,
ServletContextAware {
    private static final Logger logger = LoggerFactory.getLogger(PrefabInstallerImpl.class);
    @Autowired
    private PrefabManager prefabManager;
    @Autowired
    private PrefabRegistry prefabRegistry;
    private ServletContext servletContext;
    private ApplicationContext context;

    @Override
    public void installPrefab(Prefab prefab) {
        if (this.prefabRegistry == null) {
            return;
        }
        logger.info("Installing prefab {}", (Object)prefab.getName());
        PrefabWebApplicationContext prefabContext = new PrefabWebApplicationContext(prefab, this.context, this.servletContext);
        this.prefabRegistry.addPrefabContext(prefab.getName(), (ConfigurableApplicationContext)prefabContext);
        prefab.setInstalled(true);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.context = applicationContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setPrefabManager(PrefabManager prefabManager) {
        this.prefabManager = prefabManager;
    }

    public void setPrefabRegistry(PrefabRegistry prefabRegistry) {
        this.prefabRegistry = prefabRegistry;
    }

    public PrefabManager getPrefabManager() {
        return this.prefabManager;
    }

    public PrefabRegistry getPrefabRegistry() {
        return this.prefabRegistry;
    }

    @Override
    public void installPrefabs() {
        if (this.prefabManager == null) {
            return;
        }
        for (Prefab prefab : this.prefabManager.getPrefabs()) {
            this.installPrefab(prefab);
        }
    }

    @Override
    public void uninstallPrefabs() {
        if (this.prefabRegistry != null) {
            this.prefabManager.getPrefabs().stream().filter(Prefab::isInstalled).forEach(prefab -> {
                ConfigurableApplicationContext prefabContext = this.prefabRegistry.getPrefabContext(prefab.getName());
                WMIOUtils.closeByLogging((AutoCloseable)prefabContext);
                prefab.setInstalled(false);
            });
            this.prefabRegistry.deletePrefabContexts();
        }
        if (this.prefabManager != null) {
            for (Prefab prefab2 : this.prefabManager.getPrefabs()) {
                WMUrlClassLoader wmUrlClassLoader = (WMUrlClassLoader)prefab2.getClassLoader();
                WMIOUtils.closeByLogging((AutoCloseable)wmUrlClassLoader);
                prefab2.setClassLoader(null);
            }
            this.prefabManager.deleteAllPrefabs();
        }
    }
}

